/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jnosql.mapping.graph.configuration;

import jakarta.enterprise.context.ApplicationScoped;
import jakarta.enterprise.inject.Disposes;
import jakarta.enterprise.inject.Produces;
import java.util.Optional;
import java.util.function.Supplier;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.eclipse.jnosql.communication.CommunicationException;
import org.eclipse.jnosql.communication.graph.GraphDatabaseManager;
import org.eclipse.jnosql.communication.semistructured.DatabaseConfiguration;
import org.eclipse.jnosql.communication.semistructured.DatabaseManager;
import org.eclipse.jnosql.communication.semistructured.DatabaseManagerFactory;
import org.eclipse.jnosql.mapping.core.config.MappingConfigurations;
import org.eclipse.jnosql.mapping.core.config.MicroProfileSettings;
import org.eclipse.jnosql.mapping.reflection.Reflections;

@ApplicationScoped
class GraphManagerSupplier
implements Supplier<GraphDatabaseManager> {
    private static final Logger LOGGER = Logger.getLogger(GraphManagerSupplier.class.getName());
    private static final String DEFAULT_GRAPH_DATABASE = "graph";

    GraphManagerSupplier() {
    }

    @Override
    @Produces
    @ApplicationScoped
    public GraphDatabaseManager get() {
        Optional database;
        String db;
        MicroProfileSettings settings = MicroProfileSettings.INSTANCE;
        DatabaseConfiguration configuration = settings.get((Supplier)MappingConfigurations.GRAPH_PROVIDER, Class.class).filter(DatabaseConfiguration.class::isAssignableFrom).map(c -> (DatabaseConfiguration)Reflections.newInstance((Class)c)).orElseGet(DatabaseConfiguration::getConfiguration);
        DatabaseManagerFactory managerFactory = (DatabaseManagerFactory)configuration.apply((Object)settings);
        DatabaseManager manager = (DatabaseManager)managerFactory.apply((Object)(db = (database = settings.get((Supplier)MappingConfigurations.GRAPH_DATABASE, String.class)).orElseGet(() -> {
            LOGGER.log(Level.FINE, "The database name is required, default value `{0}` is used", DEFAULT_GRAPH_DATABASE);
            return DEFAULT_GRAPH_DATABASE;
        })));
        if (manager instanceof GraphDatabaseManager) {
            LOGGER.log(Level.FINEST, "Starting  a GraphManager instance using Eclipse MicroProfile Config, database name: " + db);
            return (GraphDatabaseManager)manager;
        }
        throw new CommunicationException("The database manager is not a GraphDatabaseManager instance, check the configuration, the current instance is: " + manager.getClass());
    }

    public void close(@Disposes GraphDatabaseManager manager) {
        LOGGER.log(Level.FINEST, "Closing GraphManager resource, database name: " + manager.name());
        manager.close();
    }
}

