/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jnosql.mapping.graph;

import jakarta.enterprise.context.ApplicationScoped;
import jakarta.enterprise.inject.Vetoed;
import jakarta.inject.Inject;
import java.util.Objects;
import java.util.function.Function;
import org.eclipse.jnosql.communication.graph.GraphDatabaseManager;
import org.eclipse.jnosql.mapping.core.Converters;
import org.eclipse.jnosql.mapping.graph.AbstractGraphTemplate;
import org.eclipse.jnosql.mapping.graph.GraphTemplate;
import org.eclipse.jnosql.mapping.metadata.EntitiesMetadata;
import org.eclipse.jnosql.mapping.semistructured.EntityConverter;
import org.eclipse.jnosql.mapping.semistructured.EventPersistManager;

@ApplicationScoped
public class GraphTemplateProducer
implements Function<GraphDatabaseManager, GraphTemplate> {
    @Inject
    private EntityConverter converter;
    @Inject
    private EventPersistManager eventManager;
    @Inject
    private EntitiesMetadata entities;
    @Inject
    private Converters converters;

    @Override
    public GraphTemplate apply(GraphDatabaseManager manager) {
        Objects.requireNonNull(manager, "manager is required");
        return new ProducerGraphTemplate(this.converter, manager, this.eventManager, this.entities, this.converters);
    }

    @Vetoed
    static class ProducerGraphTemplate
    extends AbstractGraphTemplate
    implements GraphTemplate {
        private final EntityConverter converter;
        private final GraphDatabaseManager manager;
        private final EventPersistManager eventManager;
        private final EntitiesMetadata entities;
        private final Converters converters;

        ProducerGraphTemplate(EntityConverter converter, GraphDatabaseManager manager, EventPersistManager eventManager, EntitiesMetadata entities, Converters converters) {
            this.converter = converter;
            this.manager = manager;
            this.eventManager = eventManager;
            this.entities = entities;
            this.converters = converters;
        }

        ProducerGraphTemplate() {
            this(null, null, null, null, null);
        }

        protected EntityConverter converter() {
            return this.converter;
        }

        @Override
        protected GraphDatabaseManager manager() {
            return this.manager;
        }

        protected EventPersistManager eventManager() {
            return this.eventManager;
        }

        protected EntitiesMetadata entities() {
            return this.entities;
        }

        protected Converters converters() {
            return this.converters;
        }
    }
}

