/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jnosql.mapping.graph;

import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.function.Supplier;
import org.eclipse.jnosql.mapping.graph.DefaultEdge;
import org.eclipse.jnosql.mapping.graph.Edge;
import org.eclipse.jnosql.mapping.graph.EdgeBuilder;

class DefaultEdgeBuilder<T, S>
implements EdgeBuilder,
EdgeBuilder.SourceStep<T>,
EdgeBuilder.LabelStep<T>,
EdgeBuilder.TargetStep<T, S> {
    private Object id;
    private Object source;
    private Object target;
    private Map<String, Object> properties = new HashMap<String, Object>();
    private String label;

    DefaultEdgeBuilder() {
    }

    public <I> EdgeBuilder.SourceStep<I> source(I source) {
        Objects.requireNonNull(source, "source is required");
        this.source = source;
        return this;
    }

    @Override
    public <F> EdgeBuilder.TargetStep<T, F> target(F target) {
        Objects.requireNonNull(target, "target is required");
        this.target = target;
        return this;
    }

    @Override
    public EdgeBuilder.LabelStep<T> label(String label) {
        Objects.requireNonNull(label, "label is required");
        this.label = label;
        return this;
    }

    @Override
    public EdgeBuilder.LabelStep<T> label(Supplier<String> label) {
        Objects.requireNonNull(label, "label is required");
        return this.label(label.get());
    }

    @Override
    public Edge<T, S> build() {
        return new DefaultEdge<Object, Object>(this.source, this.target, this.label, this.properties, this.id);
    }

    @Override
    public EdgeBuilder.TargetStep<T, S> property(String key, Object value) {
        Objects.requireNonNull(key, "key is required");
        Objects.requireNonNull(value, "value is required");
        this.properties.put(key, value);
        return this;
    }
}

