/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jnosql.mapping.graph;

import java.util.Collections;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import org.eclipse.jnosql.communication.Value;
import org.eclipse.jnosql.mapping.graph.Edge;

record DefaultEdge<S, T>(S source, T target, String label, Map<String, Object> properties, Object key) implements Edge<S, T>
{
    private final Map<String, Object> properties;

    @Override
    public Optional<Object> id() {
        return Optional.ofNullable(this.key);
    }

    @Override
    public <K> Optional<K> id(Class<K> type) {
        return Optional.ofNullable(this.key).map(Value::of).map(v -> v.get(type));
    }

    @Override
    public Map<String, Object> properties() {
        return Collections.unmodifiableMap(this.properties);
    }

    @Override
    public <V> Optional<V> property(String key, Class<V> type) {
        Objects.requireNonNull(key, "key is required");
        Objects.requireNonNull(type, "type is required");
        return Optional.ofNullable(this.properties.get(key)).map(Value::of).map(v -> v.get(type));
    }
}

