/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jnosql.mapping.graph;

import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Supplier;
import java.util.logging.Logger;
import org.eclipse.jnosql.communication.graph.CommunicationEdge;
import org.eclipse.jnosql.communication.graph.GraphDatabaseManager;
import org.eclipse.jnosql.communication.semistructured.CommunicationEntity;
import org.eclipse.jnosql.mapping.graph.DefaultEdge;
import org.eclipse.jnosql.mapping.graph.Edge;
import org.eclipse.jnosql.mapping.graph.GraphTemplate;
import org.eclipse.jnosql.mapping.semistructured.AbstractSemiStructuredTemplate;

public abstract class AbstractGraphTemplate
extends AbstractSemiStructuredTemplate
implements GraphTemplate {
    private static final Logger LOGGER = Logger.getLogger(AbstractGraphTemplate.class.getName());

    protected abstract GraphDatabaseManager manager();

    @Override
    public <T, E> Edge<T, E> edge(T source, Supplier<String> label, E target, Map<String, Object> properties) {
        Objects.requireNonNull(label, "label is required");
        LOGGER.fine(() -> "Creating edge for " + label);
        return this.edge(source, label.get(), target, properties);
    }

    @Override
    public <T, E> Edge<T, E> edge(Edge<T, E> edge) {
        Objects.requireNonNull(edge, "edge is required");
        return this.edge(edge.source(), edge.label(), edge.target(), edge.properties());
    }

    @Override
    public <T, E> Edge<T, E> edge(T source, String label, E target, Map<String, Object> properties) {
        Objects.requireNonNull(source, "source is required");
        Objects.requireNonNull(label, "label is required");
        Objects.requireNonNull(target, "target is required");
        Objects.requireNonNull(properties, "properties is required");
        LOGGER.fine(() -> "Creating edge for " + label + " between " + source + " and " + target);
        CommunicationEntity sourceCommunication = this.converter().toCommunication(source);
        CommunicationEntity targetCommunication = this.converter().toCommunication(target);
        CommunicationEdge communicationEdge = this.manager().edge(sourceCommunication, label, targetCommunication, properties);
        LOGGER.fine(() -> "Created edge for " + label + " between " + source + " and " + target + " with id: " + communicationEdge.id());
        Object updatedSource = this.converter().toEntity(communicationEdge.source());
        Object updatedTarget = this.converter().toEntity(communicationEdge.target());
        return new DefaultEdge<Object, Object>(updatedSource, updatedTarget, label, properties, communicationEdge.id());
    }

    @Override
    public <T, E> void delete(Edge<T, E> edge) {
        Objects.requireNonNull(edge, "edge is required");
        Object id = edge.id().orElseThrow(() -> new IllegalArgumentException("The edge does not have an id"));
        LOGGER.fine(() -> "Deleting edge for " + edge.label() + " between " + edge.source() + " and " + edge.target() + " with id: " + id);
        this.deleteEdge(id);
    }

    @Override
    public <K> void deleteEdge(K id) {
        Objects.requireNonNull(id, "id is required");
        LOGGER.fine(() -> "Deleting edge for " + id);
        this.manager().deleteEdge(id);
    }

    @Override
    public <K, T, E> Optional<Edge<T, E>> findEdgeById(K id) {
        Objects.requireNonNull(id, "id is required");
        LOGGER.fine(() -> "Finding edge for " + id);
        Optional<CommunicationEdge> edge = this.manager().findEdgeById(id);
        return edge.map(e -> {
            LOGGER.fine(() -> "Found edge for " + id);
            Object source = this.converter().toEntity(e.source());
            Object target = this.converter().toEntity(e.target());
            return new DefaultEdge<Object, Object>(source, target, e.label(), e.properties(), e.id());
        });
    }
}

