/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jnosql.mapping.graph.spi;

import jakarta.nosql.mapping.DatabaseType;
import java.lang.annotation.Annotation;
import java.lang.reflect.Type;
import java.util.Collections;
import java.util.Set;
import javax.enterprise.context.spi.CreationalContext;
import org.apache.tinkerpop.gremlin.structure.Graph;
import org.eclipse.jnosql.mapping.DatabaseQualifier;
import org.eclipse.jnosql.mapping.graph.GraphTemplate;
import org.eclipse.jnosql.mapping.graph.GraphTemplateProducer;
import org.eclipse.jnosql.mapping.spi.AbstractBean;

class TemplateBean
extends AbstractBean<GraphTemplate> {
    private final Set<Type> types = Collections.singleton(GraphTemplate.class);
    private final String provider;
    private final Set<Annotation> qualifiers;

    public TemplateBean(String provider) {
        this.provider = provider;
        this.qualifiers = Collections.singleton(DatabaseQualifier.ofGraph((String)provider));
    }

    public Class<?> getBeanClass() {
        return GraphTemplate.class;
    }

    public GraphTemplate create(CreationalContext<GraphTemplate> context) {
        GraphTemplateProducer producer = (GraphTemplateProducer)this.getInstance(GraphTemplateProducer.class);
        Graph manager = this.getGraph();
        return producer.get(manager);
    }

    private Graph getGraph() {
        return (Graph)this.getInstance(Graph.class, (Annotation)DatabaseQualifier.ofGraph((String)this.provider));
    }

    public Set<Type> getTypes() {
        return this.types;
    }

    public Set<Annotation> getQualifiers() {
        return this.qualifiers;
    }

    public String getId() {
        return GraphTemplate.class.getName() + DatabaseType.COLUMN + "-" + this.provider;
    }
}

