/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jnosql.mapping.graph.spi;

import jakarta.nosql.mapping.DatabaseType;
import jakarta.nosql.mapping.Repository;
import java.lang.reflect.Modifier;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import java.util.logging.Logger;
import javax.enterprise.event.Observes;
import javax.enterprise.inject.spi.AfterBeanDiscovery;
import javax.enterprise.inject.spi.Bean;
import javax.enterprise.inject.spi.Extension;
import javax.enterprise.inject.spi.ProcessAnnotatedType;
import javax.enterprise.inject.spi.ProcessProducer;
import org.apache.tinkerpop.gremlin.structure.Graph;
import org.eclipse.jnosql.mapping.DatabaseMetadata;
import org.eclipse.jnosql.mapping.Databases;
import org.eclipse.jnosql.mapping.graph.query.RepositoryGraphBean;
import org.eclipse.jnosql.mapping.graph.spi.TemplateBean;

public class GraphExtension
implements Extension {
    private static final Logger LOGGER = Logger.getLogger(GraphExtension.class.getName());
    private final Set<DatabaseMetadata> databases = new HashSet<DatabaseMetadata>();
    private final Collection<Class<?>> crudTypes = new HashSet();

    <T extends Repository> void observes(@Observes ProcessAnnotatedType<T> repo) {
        Class javaClass = repo.getAnnotatedType().getJavaClass();
        if (Repository.class.equals((Object)javaClass)) {
            return;
        }
        if (Arrays.asList(javaClass.getInterfaces()).contains(Repository.class) && Modifier.isInterface(javaClass.getModifiers())) {
            this.crudTypes.add(javaClass);
        }
    }

    <T, X extends Graph> void observes(@Observes ProcessProducer<T, X> pp) {
        Databases.addDatabase(pp, (DatabaseType)DatabaseType.GRAPH, this.databases);
    }

    void onAfterBeanDiscovery(@Observes AfterBeanDiscovery afterBeanDiscovery) {
        LOGGER.info(String.format("Processing graph extension: %d databases crud %d found", this.databases.size(), this.crudTypes.size()));
        LOGGER.info("Processing repositories as a Graph implementation: " + this.crudTypes);
        this.databases.forEach(type -> {
            TemplateBean bean = new TemplateBean(type.getProvider());
            afterBeanDiscovery.addBean((Bean)bean);
        });
        this.crudTypes.forEach(type -> {
            if (!this.databases.contains(DatabaseMetadata.DEFAULT_GRAPH)) {
                afterBeanDiscovery.addBean((Bean)new RepositoryGraphBean((Class)type, ""));
            }
            this.databases.forEach(database -> afterBeanDiscovery.addBean((Bean)new RepositoryGraphBean((Class)type, database.getProvider())));
        });
    }
}

