/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jnosql.mapping.graph.query;

import jakarta.nosql.mapping.Converters;
import jakarta.nosql.mapping.DatabaseType;
import jakarta.nosql.mapping.Repository;
import java.lang.annotation.Annotation;
import java.lang.reflect.Proxy;
import java.lang.reflect.Type;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import javax.enterprise.context.spi.CreationalContext;
import org.apache.tinkerpop.gremlin.structure.Graph;
import org.eclipse.jnosql.mapping.DatabaseQualifier;
import org.eclipse.jnosql.mapping.graph.GraphConverter;
import org.eclipse.jnosql.mapping.graph.GraphTemplate;
import org.eclipse.jnosql.mapping.graph.query.GraphRepositoryProxy;
import org.eclipse.jnosql.mapping.reflection.EntitiesMetadata;
import org.eclipse.jnosql.mapping.spi.AbstractBean;
import org.eclipse.jnosql.mapping.util.AnnotationLiteralUtil;

public class RepositoryGraphBean
extends AbstractBean<Repository> {
    private final Class type;
    private final Set<Type> types;
    private final String provider;
    private final Set<Annotation> qualifiers;

    public RepositoryGraphBean(Class type, String provider) {
        this.type = type;
        this.types = Collections.singleton(type);
        this.provider = provider;
        if (provider.isEmpty()) {
            this.qualifiers = new HashSet<Annotation>();
            this.qualifiers.add((Annotation)DatabaseQualifier.ofGraph());
            this.qualifiers.add((Annotation)AnnotationLiteralUtil.DEFAULT_ANNOTATION);
            this.qualifiers.add((Annotation)AnnotationLiteralUtil.ANY_ANNOTATION);
        } else {
            this.qualifiers = Collections.singleton(DatabaseQualifier.ofGraph((String)provider));
        }
    }

    public Class<?> getBeanClass() {
        return this.type;
    }

    public Repository create(CreationalContext<Repository> creationalContext) {
        EntitiesMetadata entities = (EntitiesMetadata)this.getInstance(EntitiesMetadata.class);
        GraphTemplate repository = this.provider.isEmpty() ? (GraphTemplate)this.getInstance(GraphTemplate.class) : (GraphTemplate)this.getInstance(GraphTemplate.class, (Annotation)DatabaseQualifier.ofGraph((String)this.provider));
        GraphConverter converter = (GraphConverter)this.getInstance(GraphConverter.class);
        Graph graph = this.provider.isEmpty() ? (Graph)this.getInstance(Graph.class) : (Graph)this.getInstance(Graph.class, (Annotation)DatabaseQualifier.ofGraph((String)this.provider));
        Converters converters = (Converters)this.getInstance(Converters.class);
        GraphRepositoryProxy handler = new GraphRepositoryProxy(repository, entities, this.type, graph, converter, converters);
        return (Repository)Proxy.newProxyInstance(this.type.getClassLoader(), new Class[]{this.type}, handler);
    }

    public Set<Type> getTypes() {
        return this.types;
    }

    public Set<Annotation> getQualifiers() {
        return this.qualifiers;
    }

    public String getId() {
        return this.type.getName() + "@" + DatabaseType.GRAPH + "-" + this.provider;
    }
}

