/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jnosql.mapping.graph.query;

import jakarta.nosql.mapping.Converters;
import jakarta.nosql.mapping.DynamicQueryException;
import java.lang.reflect.Method;
import java.util.Collection;
import java.util.Collections;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;
import org.apache.tinkerpop.gremlin.process.traversal.dsl.graph.GraphTraversal;
import org.apache.tinkerpop.gremlin.structure.Vertex;
import org.eclipse.jnosql.mapping.reflection.EntityMetadata;
import org.eclipse.jnosql.mapping.util.ConverterUtil;

final class GraphQueryMethod {
    private final EntityMetadata mapping;
    private final GraphTraversal<Vertex, Vertex> traversal;
    private final Object[] args;
    private final Converters converters;
    private final Method method;
    private int counter = 0;

    GraphQueryMethod(EntityMetadata mapping, GraphTraversal<Vertex, Vertex> traversal, Converters converters, Method method, Object[] args) {
        this.mapping = mapping;
        this.traversal = traversal;
        this.args = args;
        this.converters = converters;
        this.method = method;
    }

    public Method getMethod() {
        return this.method;
    }

    public String getEntityName() {
        return this.mapping.getName();
    }

    public EntityMetadata getMapping() {
        return this.mapping;
    }

    public GraphTraversal<Vertex, Vertex> getTraversal() {
        return this.traversal;
    }

    public Object getValue(String name) {
        Object value = this.getValue();
        return ConverterUtil.getValue((Object)value, (EntityMetadata)this.mapping, (String)name, (Converters)this.converters);
    }

    public Collection<?> getInValue(String name) {
        Object value = this.getValue();
        if (value instanceof Iterable) {
            return StreamSupport.stream(((Iterable)value).spliterator(), false).map(v -> ConverterUtil.getValue((Object)v, (EntityMetadata)this.mapping, (String)name, (Converters)this.converters)).collect(Collectors.toList());
        }
        return Collections.singletonList(ConverterUtil.getValue((Object)value, (EntityMetadata)this.mapping, (String)name, (Converters)this.converters));
    }

    private Object getValue() {
        if (this.counter + 1 > this.args.length) {
            throw new DynamicQueryException(String.format("There is a missed argument in the method %s", this.method));
        }
        Object value = this.args[this.counter];
        ++this.counter;
        return value;
    }
}

