/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jnosql.mapping.graph;

import javax.annotation.Priority;
import javax.enterprise.inject.Alternative;
import javax.enterprise.inject.Instance;
import javax.inject.Inject;
import javax.interceptor.AroundInvoke;
import javax.interceptor.Interceptor;
import javax.interceptor.InvocationContext;
import org.apache.tinkerpop.gremlin.structure.Graph;
import org.apache.tinkerpop.gremlin.structure.Transaction;
import org.eclipse.jnosql.mapping.graph.GraphTransactionUtil;
import org.eclipse.jnosql.mapping.graph.Transactional;

@Transactional
@Interceptor
@Alternative
@Priority(value=2000)
class TransactionalInterceptor {
    @Inject
    private Instance<Graph> graph;

    TransactionalInterceptor() {
    }

    @AroundInvoke
    public Object manageTransaction(InvocationContext context) throws Exception {
        Transaction transaction = ((Graph)this.graph.get()).tx();
        GraphTransactionUtil.lock(transaction);
        if (!transaction.isOpen()) {
            transaction.open();
        }
        try {
            Object proceed = context.proceed();
            transaction.commit();
            Object object = proceed;
            return object;
        }
        catch (Exception exception) {
            transaction.rollback();
            throw exception;
        }
        finally {
            GraphTransactionUtil.unlock();
        }
    }
}

