/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jnosql.mapping.graph;

import java.util.Objects;
import java.util.function.Supplier;
import java.util.logging.Logger;
import org.apache.tinkerpop.gremlin.structure.Graph;
import org.apache.tinkerpop.gremlin.structure.Transaction;
import org.eclipse.jnosql.mapping.config.MappingConfigurations;
import org.eclipse.jnosql.mapping.config.MicroProfileSettings;

final class GraphTransactionUtil {
    private static final Logger LOGGER = Logger.getLogger(GraphTransactionUtil.class.getName());
    private static final ThreadLocal<Transaction> THREAD_LOCAL = new ThreadLocal();

    private GraphTransactionUtil() {
    }

    static void lock(Transaction transaction) {
        THREAD_LOCAL.set(transaction);
    }

    static void unlock() {
        THREAD_LOCAL.remove();
    }

    static void transaction(Graph graph) {
        if (GraphTransactionUtil.isAutomatic() && GraphTransactionUtil.isNotLock() && Objects.nonNull(graph)) {
            try {
                Transaction transaction = graph.tx();
                if (transaction != null) {
                    transaction.commit();
                }
            }
            catch (Exception exception) {
                LOGGER.info("Unable to do transaction automatically in the graph, reason: " + exception.getMessage());
            }
        }
    }

    static boolean isAutomatic() {
        return MicroProfileSettings.INSTANCE.get((Supplier)MappingConfigurations.GRAPH_TRANSACTION_AUTOMATIC, String.class).map(Boolean::valueOf).orElse(true);
    }

    private static boolean isNotLock() {
        return THREAD_LOCAL.get() == null;
    }
}

