/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jnosql.mapping.graph;

import jakarta.nosql.mapping.AttributeConverter;
import jakarta.nosql.mapping.Converters;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import org.apache.tinkerpop.gremlin.structure.Property;
import org.eclipse.jnosql.mapping.graph.DefaultProperty;
import org.eclipse.jnosql.mapping.graph.GraphConverter;
import org.eclipse.jnosql.mapping.reflection.FieldMapping;
import org.eclipse.jnosql.mapping.reflection.MappingType;

final class FieldGraph {
    private final Object value;
    private final FieldMapping field;

    private FieldGraph(Object value, FieldMapping field) {
        this.value = value;
        this.field = field;
    }

    public Object getValue() {
        return this.value;
    }

    public FieldMapping getField() {
        return this.field;
    }

    public boolean isNotEmpty() {
        return this.value != null;
    }

    public boolean isId() {
        return this.field.isId();
    }

    public boolean isNotId() {
        return !this.isId();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof FieldGraph)) {
            return false;
        }
        FieldGraph that = (FieldGraph)o;
        return Objects.equals(this.value, that.value) && Objects.equals(this.field, that.field);
    }

    public int hashCode() {
        return Objects.hash(this.value, this.field);
    }

    public String toString() {
        return "FieldGraph{value=" + this.value + ", field=" + this.field + "}";
    }

    public static FieldGraph of(Object value, FieldMapping field) {
        return new FieldGraph(value, field);
    }

    public <X, Y> List<Property<?>> toElements(GraphConverter converter, Converters converters) {
        if (MappingType.EMBEDDED.equals((Object)this.field.getType())) {
            return converter.getProperties(this.value);
        }
        Optional optionalConverter = this.field.getConverter();
        if (optionalConverter.isPresent()) {
            AttributeConverter attributeConverter = converters.get((Class)optionalConverter.get());
            return Collections.singletonList(DefaultProperty.of(this.field.getName(), attributeConverter.convertToDatabaseColumn(this.value)));
        }
        return Collections.singletonList(DefaultProperty.of(this.field.getName(), this.value));
    }

    public <X, Y> Property toElement(Converters converters) {
        Optional optionalConverter = this.field.getConverter();
        if (optionalConverter.isPresent()) {
            AttributeConverter attributeConverter = converters.get((Class)optionalConverter.get());
            return DefaultProperty.of(this.field.getName(), attributeConverter.convertToDatabaseColumn(this.value));
        }
        return DefaultProperty.of(this.field.getName(), this.value);
    }
}

