/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jnosql.mapping.graph;

import jakarta.nosql.NonUniqueResultException;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.tinkerpop.gremlin.process.traversal.dsl.graph.GraphTraversal;
import org.apache.tinkerpop.gremlin.structure.Vertex;
import org.eclipse.jnosql.mapping.graph.ValueMapTraversal;

class DefaultValueMapTraversal
implements ValueMapTraversal {
    private final Supplier<GraphTraversal<?, ?>> supplier;
    private final Function<GraphTraversal<?, ?>, GraphTraversal<Vertex, Map<Object, Object>>> flow;

    DefaultValueMapTraversal(Supplier<GraphTraversal<?, ?>> supplier, Function<GraphTraversal<?, ?>, GraphTraversal<Vertex, Map<Object, Object>>> flow) {
        this.supplier = supplier;
        this.flow = flow;
    }

    @Override
    public Stream<Map<String, Object>> stream() {
        return this.flow.apply(this.supplier.get()).toList().stream().map(this.toMap());
    }

    @Override
    public Stream<Map<String, Object>> next(int limit) {
        return this.flow.apply(this.supplier.get()).next(limit).stream().map(this.toMap());
    }

    @Override
    public Map<String, Object> next() {
        return this.flow.apply(this.supplier.get()).tryNext().map(this.toMap()).orElse(Collections.emptyMap());
    }

    @Override
    public Optional<Map<String, Object>> getSingleResult() {
        List<Map<String, Object>> result = this.getResultList();
        if (result.isEmpty()) {
            return Optional.empty();
        }
        if (result.size() == 1) {
            return Optional.of(result.get(0));
        }
        throw new NonUniqueResultException("The Edge traversal query returns more than one result");
    }

    @Override
    public List<Map<String, Object>> getResultList() {
        return this.stream().collect(Collectors.toList());
    }

    @Override
    public long count() {
        return this.flow.apply(this.supplier.get()).count().tryNext().orElse(0L);
    }

    private Function<Map<?, ?>, Map<String, Object>> toMap() {
        return map -> map.entrySet().stream().collect(Collectors.toMap(k -> k.getKey().toString(), Map.Entry::getValue));
    }
}

