/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jnosql.mapping.graph;

import java.util.Objects;
import java.util.function.Function;
import java.util.function.UnaryOperator;
import javax.enterprise.context.ApplicationScoped;
import javax.inject.Inject;
import org.apache.tinkerpop.gremlin.structure.Vertex;
import org.eclipse.jnosql.mapping.graph.GraphConverter;
import org.eclipse.jnosql.mapping.graph.GraphEventPersistManager;
import org.eclipse.jnosql.mapping.graph.GraphWorkflow;

@ApplicationScoped
class DefaultGraphWorkflow
implements GraphWorkflow {
    private GraphEventPersistManager graphEventPersistManager;
    private GraphConverter converter;

    DefaultGraphWorkflow() {
    }

    @Inject
    DefaultGraphWorkflow(GraphEventPersistManager graphEventPersistManager, GraphConverter converter) {
        this.graphEventPersistManager = graphEventPersistManager;
        this.converter = converter;
    }

    @Override
    public <T> T flow(T entity, UnaryOperator<Vertex> action) {
        Function<T, T> flow = this.getFlow(entity, action);
        return flow.apply(entity);
    }

    private <T> Function<T, T> getFlow(T entity, UnaryOperator<Vertex> action) {
        UnaryOperator validation = t -> Objects.requireNonNull(t, "entity is required");
        UnaryOperator firePreEntity = t -> {
            this.graphEventPersistManager.firePreEntity(t);
            return t;
        };
        UnaryOperator firePreGraphEntity = t -> {
            this.graphEventPersistManager.firePreGraphEntity(t);
            return t;
        };
        Function<Object, Vertex> converterGraph = t -> this.converter.toVertex(t);
        UnaryOperator firePreGraph = t -> {
            this.graphEventPersistManager.firePreGraph((Vertex)t);
            return t;
        };
        UnaryOperator firePostGraph = t -> {
            this.graphEventPersistManager.firePostGraph((Vertex)t);
            return t;
        };
        Function<Vertex, Object> converterEntity = t -> this.converter.toEntity(entity, (Vertex)t);
        UnaryOperator firePostEntity = t -> {
            this.graphEventPersistManager.firePostEntity(t);
            return t;
        };
        UnaryOperator firePostGraphEntity = t -> {
            this.graphEventPersistManager.firePostGraphEntity(t);
            return t;
        };
        return validation.andThen(firePreEntity).andThen(firePreGraphEntity).andThen(converterGraph).andThen(firePreGraph).andThen(action).andThen(firePostGraph).andThen(converterEntity).andThen(firePostEntity).andThen(firePostGraphEntity);
    }
}

