/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jnosql.mapping.graph;

import jakarta.nosql.NonUniqueResultException;
import java.util.Iterator;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.function.Supplier;
import java.util.stream.Stream;
import org.apache.tinkerpop.gremlin.process.traversal.P;
import org.apache.tinkerpop.gremlin.process.traversal.Traverser;
import org.apache.tinkerpop.gremlin.process.traversal.dsl.graph.GraphTraversal;
import org.apache.tinkerpop.gremlin.structure.Edge;
import org.apache.tinkerpop.gremlin.structure.T;
import org.apache.tinkerpop.gremlin.structure.Vertex;
import org.eclipse.jnosql.mapping.graph.AbstractEdgeTraversal;
import org.eclipse.jnosql.mapping.graph.DefaultEdgeRepeatTraversal;
import org.eclipse.jnosql.mapping.graph.DefaultEdgeTraversalOrder;
import org.eclipse.jnosql.mapping.graph.DefaultValueMapTraversal;
import org.eclipse.jnosql.mapping.graph.DefaultVertexTraversal;
import org.eclipse.jnosql.mapping.graph.EdgeEntity;
import org.eclipse.jnosql.mapping.graph.EdgeRepeatTraversal;
import org.eclipse.jnosql.mapping.graph.EdgeTraversal;
import org.eclipse.jnosql.mapping.graph.EdgeTraversalOrder;
import org.eclipse.jnosql.mapping.graph.GraphConverter;
import org.eclipse.jnosql.mapping.graph.ValueMapTraversal;
import org.eclipse.jnosql.mapping.graph.VertexTraversal;

class DefaultEdgeTraversal
extends AbstractEdgeTraversal
implements EdgeTraversal {
    DefaultEdgeTraversal(Supplier<GraphTraversal<?, ?>> supplier, Function<GraphTraversal<?, ?>, GraphTraversal<Vertex, Edge>> flow, GraphConverter converter) {
        super(supplier, flow, converter);
    }

    @Override
    public EdgeTraversal has(String propertyKey) {
        Objects.requireNonNull(propertyKey, "propertyKey is required");
        return new DefaultEdgeTraversal(this.supplier, this.flow.andThen(g -> g.has(propertyKey)), this.converter);
    }

    @Override
    public EdgeTraversal has(String propertyKey, Object value) {
        Objects.requireNonNull(propertyKey, "propertyKey is required");
        Objects.requireNonNull(value, "value is required");
        return new DefaultEdgeTraversal(this.supplier, this.flow.andThen(g -> g.has(propertyKey, value)), this.converter);
    }

    @Override
    public EdgeTraversal has(String propertyKey, P<?> predicate) {
        Objects.requireNonNull(propertyKey, "propertyKey is required");
        Objects.requireNonNull(predicate, "predicate is required");
        return new DefaultEdgeTraversal(this.supplier, this.flow.andThen(g -> g.has(propertyKey, predicate)), this.converter);
    }

    @Override
    public EdgeTraversal has(T accessor, Object value) {
        Objects.requireNonNull(accessor, "accessor is required");
        Objects.requireNonNull(value, "value is required");
        return new DefaultEdgeTraversal(this.supplier, this.flow.andThen(g -> g.has(accessor, value)), this.converter);
    }

    @Override
    public EdgeTraversal has(T accessor, P<?> predicate) {
        Objects.requireNonNull(accessor, "accessor is required");
        Objects.requireNonNull(predicate, "predicate is required");
        return new DefaultEdgeTraversal(this.supplier, this.flow.andThen(g -> g.has(accessor, predicate)), this.converter);
    }

    @Override
    public EdgeTraversal hasNot(String propertyKey) {
        Objects.requireNonNull(propertyKey, "propertyKey is required");
        return new DefaultEdgeTraversal(this.supplier, this.flow.andThen(g -> g.hasNot(propertyKey)), this.converter);
    }

    @Override
    public EdgeTraversal filter(Predicate<EdgeEntity> predicate) {
        Objects.requireNonNull(predicate, "predicate is required");
        Predicate<Traverser> p = e -> predicate.test(this.converter.toEdgeEntity((Edge)e.get()));
        return new DefaultEdgeTraversal(this.supplier, this.flow.andThen(g -> g.filter(p)), this.converter);
    }

    @Override
    public EdgeTraversal limit(long limit) {
        return new DefaultEdgeTraversal(this.supplier, this.flow.andThen(g -> g.limit(limit)), this.converter);
    }

    @Override
    public EdgeTraversal range(long start, long end) {
        return new DefaultEdgeTraversal(this.supplier, this.flow.andThen(g -> g.range(start, end)), this.converter);
    }

    @Override
    public EdgeRepeatTraversal repeat() {
        return new DefaultEdgeRepeatTraversal(this.supplier, this.flow, this.converter);
    }

    @Override
    public VertexTraversal inV() {
        return new DefaultVertexTraversal(this.supplier, this.flow.andThen(GraphTraversal::inV), this.converter);
    }

    @Override
    public VertexTraversal outV() {
        return new DefaultVertexTraversal(this.supplier, this.flow.andThen(GraphTraversal::outV), this.converter);
    }

    @Override
    public VertexTraversal bothV() {
        return new DefaultVertexTraversal(this.supplier, this.flow.andThen(GraphTraversal::bothV), this.converter);
    }

    @Override
    public EdgeTraversal dedup(String ... labels) {
        return new DefaultEdgeTraversal(this.supplier, this.flow.andThen(g -> g.dedup(labels)), this.converter);
    }

    @Override
    public Optional<EdgeEntity> next() {
        Optional edgeOptional = ((GraphTraversal)this.flow.apply((GraphTraversal)this.supplier.get())).tryNext();
        if (edgeOptional.isPresent()) {
            Edge edge = (Edge)edgeOptional.get();
            return Optional.of(this.converter.toEdgeEntity(edge));
        }
        return Optional.empty();
    }

    @Override
    public Optional<EdgeEntity> getSingleResult() {
        Stream<EdgeEntity> result = this.getResult();
        Iterator iterator = result.iterator();
        if (!iterator.hasNext()) {
            return Optional.empty();
        }
        EdgeEntity entity = (EdgeEntity)iterator.next();
        if (!iterator.hasNext()) {
            return Optional.of(entity);
        }
        throw new NonUniqueResultException("The Edge traversal query returns more than one result");
    }

    @Override
    public Stream<EdgeEntity> getResult() {
        return this.stream();
    }

    @Override
    public Stream<EdgeEntity> stream() {
        return ((GraphTraversal)this.flow.apply((GraphTraversal)this.supplier.get())).toList().stream().map(this.converter::toEdgeEntity);
    }

    @Override
    public Stream<EdgeEntity> next(int limit) {
        return ((GraphTraversal)this.flow.apply((GraphTraversal)this.supplier.get())).next(limit).stream().map(this.converter::toEdgeEntity);
    }

    @Override
    public ValueMapTraversal valueMap(String ... propertyKeys) {
        return new DefaultValueMapTraversal(this.supplier, this.flow.andThen(g -> g.valueMap(false, propertyKeys)));
    }

    @Override
    public EdgeTraversalOrder orderBy(String property) {
        Objects.requireNonNull(property, "property is required");
        return new DefaultEdgeTraversalOrder(this.supplier, this.flow, this.converter, property);
    }

    @Override
    public long count() {
        return ((GraphTraversal)this.flow.apply((GraphTraversal)this.supplier.get())).count().tryNext().orElse(0L);
    }
}

