/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jnosql.mapping.graph;

import jakarta.nosql.Value;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import org.apache.tinkerpop.gremlin.structure.Edge;
import org.apache.tinkerpop.gremlin.structure.Property;
import org.eclipse.jnosql.mapping.graph.DefaultProperty;
import org.eclipse.jnosql.mapping.graph.EdgeEntity;

class DefaultEdgeEntity<O, I>
implements EdgeEntity {
    private final O outgoing;
    private final Edge edge;
    private final I incoming;

    DefaultEdgeEntity(Edge edge, I incoming, O outgoing) {
        this.edge = edge;
        this.incoming = incoming;
        this.outgoing = outgoing;
    }

    @Override
    public Object getId() {
        return this.edge.id();
    }

    @Override
    public <T> T getId(Class<T> type) {
        Objects.requireNonNull(type, "type is required");
        return (T)Value.of((Object)this.edge.id()).get(type);
    }

    @Override
    public String getLabel() {
        return this.edge.label();
    }

    public I getIncoming() {
        return this.incoming;
    }

    public O getOutgoing() {
        return this.outgoing;
    }

    @Override
    public List<Property> getProperties() {
        return this.edge.keys().stream().map(k -> DefaultProperty.of(k, this.edge.value(k))).collect(Collectors.collectingAndThen(Collectors.toList(), Collections::unmodifiableList));
    }

    @Override
    public void add(String key, Object value) {
        Objects.requireNonNull(key, "key is required");
        Objects.requireNonNull(value, "value is required");
        this.edge.property(key, value);
    }

    @Override
    public void add(String key, Value value) {
        Objects.requireNonNull(key, "key is required");
        Objects.requireNonNull(value, "value is required");
        this.edge.property(key, value.get());
    }

    @Override
    public void remove(String key) {
        Objects.requireNonNull(key, "key is required");
        Property property = this.edge.property(key);
        property.ifPresent(o -> property.remove());
    }

    @Override
    public Optional<Value> get(String key) {
        Objects.requireNonNull(key, "key is required");
        Property property = this.edge.property(key);
        if (property.isPresent()) {
            return Optional.of(Value.of((Object)property.value()));
        }
        return Optional.empty();
    }

    @Override
    public boolean isEmpty() {
        return this.edge.keys().isEmpty();
    }

    @Override
    public int size() {
        return this.edge.keys().size();
    }

    @Override
    public void delete() {
        this.edge.remove();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof DefaultEdgeEntity)) {
            return false;
        }
        DefaultEdgeEntity that = (DefaultEdgeEntity)o;
        return Objects.equals(this.edge, that.edge) && Objects.equals(this.incoming, that.incoming) && Objects.equals(this.outgoing, that.outgoing);
    }

    public int hashCode() {
        return Objects.hash(this.edge, this.incoming, this.outgoing);
    }

    public String toString() {
        return this.outgoing + "---" + this.edge.label() + " --->" + this.incoming;
    }
}

