/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jnosql.mapping.graph;

import jakarta.nosql.NonUniqueResultException;
import jakarta.nosql.mapping.Converters;
import jakarta.nosql.mapping.EntityNotFoundException;
import jakarta.nosql.mapping.IdNotFoundException;
import jakarta.nosql.mapping.PreparedStatement;
import java.time.Duration;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.function.Supplier;
import java.util.function.UnaryOperator;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import org.apache.tinkerpop.gremlin.process.traversal.Traverser;
import org.apache.tinkerpop.gremlin.process.traversal.dsl.graph.GraphTraversal;
import org.apache.tinkerpop.gremlin.process.traversal.dsl.graph.GraphTraversalSource;
import org.apache.tinkerpop.gremlin.structure.Direction;
import org.apache.tinkerpop.gremlin.structure.Edge;
import org.apache.tinkerpop.gremlin.structure.Element;
import org.apache.tinkerpop.gremlin.structure.Graph;
import org.apache.tinkerpop.gremlin.structure.T;
import org.apache.tinkerpop.gremlin.structure.Transaction;
import org.apache.tinkerpop.gremlin.structure.Vertex;
import org.eclipse.jnosql.mapping.graph.DefaultEdgeEntity;
import org.eclipse.jnosql.mapping.graph.DefaultEdgeTraversal;
import org.eclipse.jnosql.mapping.graph.DefaultPreparedStatement;
import org.eclipse.jnosql.mapping.graph.DefaultVertexTraversal;
import org.eclipse.jnosql.mapping.graph.EdgeEntity;
import org.eclipse.jnosql.mapping.graph.EdgeTraversal;
import org.eclipse.jnosql.mapping.graph.GraphConverter;
import org.eclipse.jnosql.mapping.graph.GraphTemplate;
import org.eclipse.jnosql.mapping.graph.GraphTransactionUtil;
import org.eclipse.jnosql.mapping.graph.GraphWorkflow;
import org.eclipse.jnosql.mapping.graph.GremlinExecutor;
import org.eclipse.jnosql.mapping.graph.VertexTraversal;
import org.eclipse.jnosql.mapping.reflection.EntitiesMetadata;
import org.eclipse.jnosql.mapping.reflection.EntityMetadata;
import org.eclipse.jnosql.mapping.reflection.FieldMapping;
import org.eclipse.jnosql.mapping.util.ConverterUtil;

public abstract class AbstractGraphTemplate
implements GraphTemplate {
    private static final Function<GraphTraversal<?, ?>, GraphTraversal<Vertex, Vertex>> INITIAL_VERTEX = g -> g;
    private static final Function<GraphTraversal<?, ?>, GraphTraversal<Vertex, Edge>> INITIAL_EDGE = g -> g;
    private GremlinExecutor gremlinExecutor;

    protected abstract Graph getGraph();

    protected abstract EntitiesMetadata getEntities();

    protected abstract GraphConverter getConverter();

    protected abstract GraphWorkflow getFlow();

    protected abstract Converters getConverters();

    private GremlinExecutor getExecutor() {
        if (Objects.isNull(this.gremlinExecutor)) {
            this.gremlinExecutor = new GremlinExecutor(this.getConverter());
        }
        return this.gremlinExecutor;
    }

    public <T> T insert(T entity) {
        Objects.requireNonNull(entity, "entity is required");
        this.checkId(entity);
        UnaryOperator save = v -> {
            GraphTransactionUtil.transaction(this.getGraph());
            return v;
        };
        return this.getFlow().flow(entity, save);
    }

    public <T> T insert(T entity, Duration ttl) {
        throw new UnsupportedOperationException("GraphTemplate does not support insert with TTL");
    }

    public <T> Iterable<T> insert(Iterable<T> entities, Duration ttl) {
        throw new UnsupportedOperationException("GraphTemplate does not support insert with TTL");
    }

    public <T> T update(T entity) {
        Objects.requireNonNull(entity, "entity is required");
        this.checkId(entity);
        if (this.isIdNull(entity)) {
            throw new IllegalStateException("to update a graph id cannot be null");
        }
        this.getVertex(entity).orElseThrow(() -> new EntityNotFoundException("Entity does not find in the update"));
        UnaryOperator update = e -> {
            Vertex vertex = this.getConverter().toVertex(entity);
            GraphTransactionUtil.transaction(this.getGraph());
            return vertex;
        };
        return this.getFlow().flow(entity, update);
    }

    public <T, K> Optional<T> find(Class<T> type, K id) {
        Objects.requireNonNull(type, "type is required");
        Objects.requireNonNull(id, "id is required");
        EntityMetadata entityMetadata = this.getEntities().get(type);
        FieldMapping idField = (FieldMapping)entityMetadata.getId().orElseThrow(() -> IdNotFoundException.newInstance((Class)type));
        Object value = ConverterUtil.getValue(id, (EntityMetadata)entityMetadata, (String)idField.getFieldName(), (Converters)this.getConverters());
        Optional vertex = this.getTraversal().V(new Object[]{value}).hasLabel(entityMetadata.getName(), new String[0]).tryNext();
        return vertex.map(this.getConverter()::toEntity);
    }

    @Override
    public <T> void delete(T idValue) {
        Objects.requireNonNull(idValue, "id is required");
        this.getTraversal().V(new Object[]{idValue}).toStream().forEach(Element::remove);
    }

    public <T, K> void delete(Class<T> type, K id) {
        Objects.requireNonNull(type, "type is required");
        Objects.requireNonNull(id, "id is required");
        EntityMetadata mapping = this.getEntities().get(type);
        this.getTraversal().V(new Object[]{id}).hasLabel(mapping.getName(), new String[0]).toStream().forEach(Element::remove);
    }

    @Override
    public <T> void deleteEdge(T idEdge) {
        Objects.requireNonNull(idEdge, "idEdge is required");
        this.getTraversal().E(new Object[]{idEdge}).toStream().forEach(Element::remove);
    }

    @Override
    public <T, K> Optional<T> find(K idValue) {
        Objects.requireNonNull(idValue, "id is required");
        Optional vertex = this.getTraversal().V(new Object[]{idValue}).tryNext();
        return vertex.map(this.getConverter()::toEntity);
    }

    public <T> Iterable<T> insert(Iterable<T> entities) {
        Objects.requireNonNull(entities, "entities is required");
        return StreamSupport.stream(entities.spliterator(), false).map(this::insert).collect(Collectors.toList());
    }

    @Override
    public <T> Iterable<T> update(Iterable<T> entities) {
        Objects.requireNonNull(entities, "entities is required");
        return StreamSupport.stream(entities.spliterator(), false).map(this::update).collect(Collectors.toList());
    }

    @Override
    public <T> void delete(Iterable<T> ids) {
        Objects.requireNonNull(ids, "ids is required");
        Object[] vertexIds = StreamSupport.stream(ids.spliterator(), false).toArray(Object[]::new);
        this.getTraversal().V(vertexIds).toStream().forEach(Element::remove);
    }

    @Override
    public <T> void deleteEdge(Iterable<T> ids) {
        Objects.requireNonNull(ids, "ids is required");
        Object[] edgeIds = StreamSupport.stream(ids.spliterator(), false).toArray(Object[]::new);
        this.getTraversal().E(edgeIds).toStream().forEach(Element::remove);
    }

    @Override
    public <O, I> EdgeEntity edge(O outgoing, String label, I incoming) {
        Objects.requireNonNull(incoming, "incoming is required");
        Objects.requireNonNull(label, "label is required");
        Objects.requireNonNull(outgoing, "outgoing is required");
        this.checkId(outgoing);
        this.checkId(incoming);
        if (this.isIdNull(outgoing)) {
            throw new IllegalStateException("outgoing Id field is required");
        }
        if (this.isIdNull(incoming)) {
            throw new IllegalStateException("incoming Id field is required");
        }
        Vertex outVertex = this.getVertex(outgoing).orElseThrow(() -> new EntityNotFoundException("Outgoing entity does not found"));
        Vertex inVertex = this.getVertex(incoming).orElseThrow(() -> new EntityNotFoundException("Incoming entity does not found"));
        Predicate<Traverser> predicate = t -> {
            Edge e = (Edge)t.get();
            return e.inVertex().id().equals(inVertex.id()) && e.outVertex().id().equals(outVertex.id());
        };
        Optional edge = this.getTraversal().V(new Object[]{outVertex.id()}).out(new String[]{label}).has(T.id, inVertex.id()).inE(new String[]{label}).filter(predicate).tryNext();
        return edge.map(edge1 -> new DefaultEdgeEntity<Object, Object>((Edge)edge1, incoming, outgoing)).orElseGet(() -> new DefaultEdgeEntity<Object, Object>(this.getEdge(label, outVertex, inVertex), incoming, outgoing));
    }

    private Edge getEdge(String label, Vertex outVertex, Vertex inVertex) {
        Edge edge = outVertex.addEdge(label, inVertex, new Object[0]);
        GraphTransactionUtil.transaction(this.getGraph());
        return edge;
    }

    @Override
    public <E> Optional<EdgeEntity> edge(E edgeId) {
        Objects.requireNonNull(edgeId, "edgeId is required");
        Optional edgeOptional = this.getTraversal().E(new Object[]{edgeId}).tryNext();
        if (edgeOptional.isPresent()) {
            Edge edge = (Edge)edgeOptional.get();
            return Optional.of(this.getConverter().toEdgeEntity(edge));
        }
        return Optional.empty();
    }

    @Override
    public <T> Collection<EdgeEntity> getEdges(T entity, Direction direction) {
        return this.getEdgesImpl(entity, direction, new String[0]);
    }

    @Override
    public <T> Collection<EdgeEntity> getEdges(T entity, Direction direction, String ... labels) {
        return this.getEdgesImpl(entity, direction, labels);
    }

    @Override
    @SafeVarargs
    public final <T> Collection<EdgeEntity> getEdges(T entity, Direction direction, Supplier<String> ... labels) {
        this.checkLabelsSupplier(labels);
        return this.getEdgesImpl(entity, direction, (String[])Stream.of(labels).map(Supplier::get).toArray(String[]::new));
    }

    @Override
    public <K> Collection<EdgeEntity> getEdgesById(K id, Direction direction, String ... labels) {
        return this.getEdgesByIdImpl(id, direction, labels);
    }

    @Override
    public <K> Collection<EdgeEntity> getEdgesById(K id, Direction direction) {
        return this.getEdgesByIdImpl(id, direction, new String[0]);
    }

    @Override
    @SafeVarargs
    public final <K> Collection<EdgeEntity> getEdgesById(K id, Direction direction, Supplier<String> ... labels) {
        this.checkLabelsSupplier(labels);
        return this.getEdgesByIdImpl(id, direction, (String[])Stream.of(labels).map(Supplier::get).toArray(String[]::new));
    }

    @Override
    public VertexTraversal getTraversalVertex(Object ... vertexIds) {
        if (Stream.of(vertexIds).anyMatch(Objects::isNull)) {
            throw new IllegalStateException("No one vertexId element cannot be null");
        }
        return new DefaultVertexTraversal(() -> this.getTraversal().V(vertexIds), INITIAL_VERTEX, this.getConverter());
    }

    @Override
    public EdgeTraversal getTraversalEdge(Object ... edgeIds) {
        if (Stream.of(edgeIds).anyMatch(Objects::isNull)) {
            throw new IllegalStateException("No one edgeId element cannot be null");
        }
        return new DefaultEdgeTraversal(() -> this.getTraversal().E(edgeIds), INITIAL_EDGE, this.getConverter());
    }

    @Override
    public Transaction getTransaction() {
        return this.getGraph().tx();
    }

    @Override
    public <T> Stream<T> query(String gremlin) {
        Objects.requireNonNull(gremlin, "query is required");
        return this.getExecutor().executeGremlin(this.getTraversal(), gremlin);
    }

    @Override
    public <T> Optional<T> singleResult(String gremlin) {
        Stream<T> entities = this.query(gremlin);
        Iterator iterator = entities.iterator();
        if (!iterator.hasNext()) {
            return Optional.empty();
        }
        Object entity = iterator.next();
        if (!iterator.hasNext()) {
            return Optional.ofNullable(entity);
        }
        throw new NonUniqueResultException("The gremlin query returns more than one result: " + gremlin);
    }

    @Override
    public PreparedStatement prepare(String gremlin) {
        Objects.requireNonNull(gremlin, "query is required");
        return new DefaultPreparedStatement(this.getExecutor(), gremlin, this.getTraversal());
    }

    protected GraphTraversalSource getTraversal() {
        return this.getGraph().traversal();
    }

    protected Iterator<Vertex> getVertices(Object id) {
        return this.getGraph().vertices(new Object[]{id});
    }

    @Override
    public long count(String label) {
        Objects.requireNonNull(label, "label is required");
        return this.getTraversal().V(new Object[0]).hasLabel(label, new String[0]).count().tryNext().orElse(0L);
    }

    @Override
    public <T> long count(Class<T> type) {
        Objects.requireNonNull(type, "entity class is required");
        return this.count(this.getEntities().get(type).getName());
    }

    private <K> Collection<EdgeEntity> getEdgesByIdImpl(K id, Direction direction, String ... labels) {
        Objects.requireNonNull(id, "id is required");
        Objects.requireNonNull(direction, "direction is required");
        Iterator<Vertex> vertices = this.getVertices(id);
        if (vertices.hasNext()) {
            ArrayList edges = new ArrayList();
            vertices.next().edges(direction, labels).forEachRemaining(edges::add);
            return edges.stream().map(this.getConverter()::toEdgeEntity).collect(Collectors.toList());
        }
        return Collections.emptyList();
    }

    private <T> Optional<Vertex> getVertex(T entity) {
        EntityMetadata entityMetadata = this.getEntities().get(entity.getClass());
        FieldMapping field = (FieldMapping)entityMetadata.getId().get();
        Object id = field.read(entity);
        Iterator<Vertex> vertices = this.getVertices(id);
        if (vertices.hasNext()) {
            return Optional.of(vertices.next());
        }
        return Optional.empty();
    }

    private <T> Collection<EdgeEntity> getEdgesImpl(T entity, Direction direction, String ... labels) {
        Objects.requireNonNull(entity, "entity is required");
        if (this.isIdNull(entity)) {
            throw new IllegalStateException("Entity id is required");
        }
        if (this.getVertex(entity).isEmpty()) {
            return Collections.emptyList();
        }
        Object id = this.getConverter().toVertex(entity).id();
        return this.getEdgesByIdImpl(id, direction, labels);
    }

    private void checkLabelsSupplier(Supplier<String>[] labels) {
        if (Stream.of(labels).anyMatch(Objects::isNull)) {
            throw new IllegalStateException("Item cannot be null");
        }
    }

    private <T> boolean isIdNull(T entity) {
        EntityMetadata entityMetadata = this.getEntities().get(entity.getClass());
        FieldMapping field = (FieldMapping)entityMetadata.getId().get();
        return Objects.isNull(field.read(entity));
    }

    private <T> void checkId(T entity) {
        EntityMetadata entityMetadata = this.getEntities().get(entity.getClass());
        entityMetadata.getId().orElseThrow(() -> IdNotFoundException.newInstance(entity.getClass()));
    }
}

