/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jnosql.mapping.document.query;

import jakarta.data.repository.Limit;
import jakarta.data.repository.Pageable;
import jakarta.data.repository.Sort;
import java.util.ArrayList;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Supplier;
import org.eclipse.jnosql.communication.document.DocumentQuery;
import org.eclipse.jnosql.mapping.core.NoSQLPage;
import org.eclipse.jnosql.mapping.core.repository.DynamicReturn;
import org.eclipse.jnosql.mapping.core.repository.SpecialParameters;
import org.eclipse.jnosql.mapping.document.MappingDocumentQuery;

public class DynamicQuery
implements Supplier<DocumentQuery> {
    private final SpecialParameters special;
    private final DocumentQuery query;

    private DynamicQuery(SpecialParameters special, DocumentQuery query) {
        this.special = special;
        this.query = query;
    }

    @Override
    public DocumentQuery get() {
        if (this.special.isEmpty()) {
            return this.query;
        }
        Optional limit = this.special.limit();
        if (this.special.hasOnlySort()) {
            ArrayList<Sort> sorts = new ArrayList<Sort>();
            sorts.addAll(this.query.sorts());
            sorts.addAll(this.special.sorts());
            long skip = limit.map(l -> l.startAt() - 1L).orElse(this.query.skip());
            long max = limit.map(Limit::maxResults).orElse((int)this.query.limit()).intValue();
            return new MappingDocumentQuery(sorts, max, skip, this.query.condition().orElse(null), this.query.name());
        }
        if (limit.isPresent()) {
            long skip = limit.map(l -> l.startAt() - 1L).orElse(this.query.skip());
            long max = limit.map(Limit::maxResults).orElse((int)this.query.limit()).intValue();
            ArrayList<Sort> sorts = this.query.sorts();
            if (!this.special.sorts().isEmpty()) {
                sorts = new ArrayList<Sort>(this.query.sorts());
                sorts.addAll(this.special.sorts());
            }
            return new MappingDocumentQuery(sorts, max, skip, this.query.condition().orElse(null), this.query.name());
        }
        return this.special.pageable().map(p -> {
            long size = p.size();
            long skip = NoSQLPage.skip((Pageable)p);
            ArrayList<Sort> sorts = this.query.sorts();
            if (!this.special.sorts().isEmpty()) {
                sorts = new ArrayList<Sort>(this.query.sorts());
                sorts.addAll(this.special.sorts());
            }
            return new MappingDocumentQuery(sorts, size, skip, this.query.condition().orElse(null), this.query.name());
        }).orElse(this.query);
    }

    public static DynamicQuery of(Object[] args, DocumentQuery query) {
        Objects.requireNonNull(args, "args is required");
        Objects.requireNonNull(query, "query is required");
        return new DynamicQuery(DynamicReturn.findSpecialParameters((Object[])args), query);
    }
}

