/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jnosql.mapping.document.query;

import jakarta.data.repository.Limit;
import jakarta.data.repository.Page;
import jakarta.data.repository.Pageable;
import jakarta.data.repository.Sort;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Function;
import java.util.stream.Stream;
import org.eclipse.jnosql.communication.Params;
import org.eclipse.jnosql.communication.document.DeleteQueryParser;
import org.eclipse.jnosql.communication.document.DocumentDeleteQuery;
import org.eclipse.jnosql.communication.document.DocumentDeleteQueryParams;
import org.eclipse.jnosql.communication.document.DocumentObserverParser;
import org.eclipse.jnosql.communication.document.DocumentQuery;
import org.eclipse.jnosql.communication.document.DocumentQueryParams;
import org.eclipse.jnosql.communication.document.SelectQueryParser;
import org.eclipse.jnosql.communication.query.DeleteQuery;
import org.eclipse.jnosql.communication.query.SelectQuery;
import org.eclipse.jnosql.communication.query.method.DeleteMethodProvider;
import org.eclipse.jnosql.communication.query.method.SelectMethodProvider;
import org.eclipse.jnosql.mapping.core.Converters;
import org.eclipse.jnosql.mapping.core.NoSQLPage;
import org.eclipse.jnosql.mapping.core.repository.DynamicReturn;
import org.eclipse.jnosql.mapping.core.repository.SpecialParameters;
import org.eclipse.jnosql.mapping.core.util.ParamsBinder;
import org.eclipse.jnosql.mapping.document.JNoSQLDocumentTemplate;
import org.eclipse.jnosql.mapping.document.MappingDocumentQuery;
import org.eclipse.jnosql.mapping.document.query.RepositoryDocumentObserverParser;
import org.eclipse.jnosql.mapping.metadata.EntityMetadata;

public abstract class BaseDocumentRepository<T> {
    private static final SelectQueryParser SELECT_PARSER = new SelectQueryParser();
    private static final DeleteQueryParser DELETE_PARSER = new DeleteQueryParser();
    private static final Object[] EMPTY_PARAM = new Object[0];
    private DocumentObserverParser parser;
    private ParamsBinder paramsBinder;

    protected abstract Converters getConverters();

    protected abstract EntityMetadata getEntityMetadata();

    protected abstract JNoSQLDocumentTemplate getTemplate();

    protected DocumentQuery getQuery(Method method, Object[] args) {
        SelectMethodProvider provider = SelectMethodProvider.INSTANCE;
        SelectQuery selectQuery = provider.apply(method, this.getEntityMetadata().name());
        DocumentQueryParams queryParams = SELECT_PARSER.apply(selectQuery, this.getParser());
        DocumentQuery query = queryParams.query();
        Params params = queryParams.params();
        this.getParamsBinder().bind(params, BaseDocumentRepository.getArgs(args), method);
        return this.updateQueryDynamically(BaseDocumentRepository.getArgs(args), query);
    }

    protected DocumentDeleteQuery getDeleteQuery(Method method, Object[] args) {
        DeleteMethodProvider deleteMethodFactory = DeleteMethodProvider.INSTANCE;
        DeleteQuery deleteQuery = deleteMethodFactory.apply(method, this.getEntityMetadata().name());
        DocumentDeleteQueryParams queryParams = DELETE_PARSER.apply(deleteQuery, this.getParser());
        DocumentDeleteQuery query = queryParams.query();
        Params params = queryParams.params();
        this.getParamsBinder().bind(params, BaseDocumentRepository.getArgs(args), method);
        return query;
    }

    private static Object[] getArgs(Object[] args) {
        return args == null ? EMPTY_PARAM : args;
    }

    protected DocumentQuery updateQueryDynamically(Object[] args, DocumentQuery query) {
        SpecialParameters special = DynamicReturn.findSpecialParameters((Object[])args);
        if (special.isEmpty()) {
            return query;
        }
        Optional limit = special.limit();
        if (special.hasOnlySort()) {
            ArrayList<Sort> sorts = new ArrayList<Sort>();
            sorts.addAll(query.sorts());
            sorts.addAll(special.sorts());
            long skip = limit.map(l -> l.startAt() - 1L).orElse(query.skip());
            long max = limit.map(Limit::maxResults).orElse((int)query.limit()).intValue();
            return new MappingDocumentQuery(sorts, max, skip, query.condition().orElse(null), query.name());
        }
        if (limit.isPresent()) {
            long skip = limit.map(l -> l.startAt() - 1L).orElse(query.skip());
            long max = limit.map(Limit::maxResults).orElse((int)query.limit()).intValue();
            return new MappingDocumentQuery(query.sorts(), max, skip, query.condition().orElse(null), query.name());
        }
        return special.pageable().map(p -> {
            long size = p.size();
            long skip = NoSQLPage.skip((Pageable)p);
            ArrayList<Sort> sorts = query.sorts();
            if (!special.sorts().isEmpty()) {
                sorts = new ArrayList<Sort>(query.sorts());
                sorts.addAll(special.sorts());
            }
            return new MappingDocumentQuery(sorts, size, skip, query.condition().orElse(null), query.name());
        }).orElse(query);
    }

    protected DocumentObserverParser getParser() {
        if (this.parser == null) {
            this.parser = new RepositoryDocumentObserverParser(this.getEntityMetadata());
        }
        return this.parser;
    }

    protected ParamsBinder getParamsBinder() {
        if (Objects.isNull(this.paramsBinder)) {
            this.paramsBinder = new ParamsBinder(this.getEntityMetadata(), this.getConverters());
        }
        return this.paramsBinder;
    }

    protected Long executeCountByQuery(DocumentQuery query) {
        return this.getTemplate().count(query);
    }

    protected boolean executeExistsByQuery(DocumentQuery query) {
        return this.getTemplate().exists(query);
    }

    protected Object executeFindByQuery(Method method, Object[] args, Class<?> typeClass, DocumentQuery query) {
        DynamicReturn dynamicReturn = DynamicReturn.builder().withClassSource(typeClass).withMethodSource(method).withResult(() -> this.getTemplate().select(query)).withSingleResult(() -> this.getTemplate().singleResult(query)).withPagination(DynamicReturn.findPageable((Object[])args)).withStreamPagination(this.streamPagination(query)).withSingleResultPagination(this.getSingleResult(query)).withPage(this.getPage(query)).build();
        return dynamicReturn.execute();
    }

    protected Function<Pageable, Page<T>> getPage(DocumentQuery query) {
        return p -> {
            Stream entities = this.getTemplate().select(query);
            return NoSQLPage.of(entities.toList(), (Pageable)p);
        };
    }

    protected Function<Pageable, Optional<T>> getSingleResult(DocumentQuery query) {
        return p -> this.getTemplate().singleResult(query);
    }

    protected Function<Pageable, Stream<T>> streamPagination(DocumentQuery query) {
        return p -> this.getTemplate().select(query);
    }
}

