/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jnosql.mapping.document;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.eclipse.jnosql.communication.TypeReference;
import org.eclipse.jnosql.communication.TypeSupplier;
import org.eclipse.jnosql.communication.document.Document;
import org.eclipse.jnosql.mapping.document.DocumentEntityConverter;
import org.eclipse.jnosql.mapping.metadata.ConstructorBuilder;
import org.eclipse.jnosql.mapping.metadata.EntitiesMetadata;
import org.eclipse.jnosql.mapping.metadata.FieldParameterMetadata;
import org.eclipse.jnosql.mapping.metadata.GenericParameterMetaData;
import org.eclipse.jnosql.mapping.metadata.MappingType;
import org.eclipse.jnosql.mapping.metadata.ParameterMetaData;

/*
 * Uses 'sealed' constructs - enablewith --sealed true
 */
enum ParameterConverter {
    DEFAULT{

        @Override
        void convert(DocumentEntityConverter converter, Document document, ParameterMetaData metaData, ConstructorBuilder builder) {
            metaData.converter().ifPresentOrElse(c -> {
                Object value = converter.getConverters().get((FieldParameterMetadata)metaData).convertToEntityAttribute(document.get());
                builder.add(value);
            }, () -> builder.add(document.get(metaData.type())));
        }
    }
    ,
    ENTITY{

        @Override
        void convert(DocumentEntityConverter converter, Document document, ParameterMetaData metaData, ConstructorBuilder builder) {
            Object value = document.get();
            if (value instanceof Map) {
                Map map = (Map)value;
                ArrayList<Document> documents = new ArrayList<Document>();
                for (Map.Entry entry : map.entrySet()) {
                    documents.add(Document.of((String)entry.getKey().toString(), entry.getValue()));
                }
                Object entity = converter.toEntity(metaData.type(), documents);
                builder.add(entity);
            } else {
                List documents = (List)document.get((TypeSupplier)new TypeReference<List<Document>>(){});
                Object entity = converter.toEntity(metaData.type(), documents);
                builder.add(entity);
            }
        }
    }
    ,
    COLLECTION{

        @Override
        void convert(DocumentEntityConverter converter, Document document, ParameterMetaData metaData, ConstructorBuilder builder) {
            GenericParameterMetaData genericParameter = (GenericParameterMetaData)metaData;
            Collection elements = genericParameter.collectionInstance();
            List embeddable = (List)document.get();
            for (List columnList : embeddable) {
                Object element = converter.toEntity(genericParameter.elementType(), columnList);
                elements.add(element);
            }
            builder.add((Object)elements);
        }
    };


    abstract void convert(DocumentEntityConverter var1, Document var2, ParameterMetaData var3, ConstructorBuilder var4);

    static ParameterConverter of(ParameterMetaData parameter, EntitiesMetadata entities) {
        return switch (parameter.mappingType()) {
            case MappingType.COLLECTION -> ParameterConverter.validateCollection(parameter, entities);
            case MappingType.ENTITY -> ENTITY;
            default -> DEFAULT;
        };
    }

    private static ParameterConverter validateCollection(ParameterMetaData parameter, EntitiesMetadata entities) {
        GenericParameterMetaData genericParameter = (GenericParameterMetaData)parameter;
        Class type = genericParameter.elementType();
        if (entities.findByClassName(type.getName()).isPresent()) {
            return COLLECTION;
        }
        return DEFAULT;
    }
}

