/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jnosql.mapping.document;

import jakarta.enterprise.context.ApplicationScoped;
import jakarta.enterprise.inject.Vetoed;
import jakarta.inject.Inject;
import java.util.Objects;
import org.eclipse.jnosql.communication.document.DocumentManager;
import org.eclipse.jnosql.mapping.core.Converters;
import org.eclipse.jnosql.mapping.document.AbstractDocumentTemplate;
import org.eclipse.jnosql.mapping.document.DocumentEntityConverter;
import org.eclipse.jnosql.mapping.document.DocumentEventPersistManager;
import org.eclipse.jnosql.mapping.document.JNoSQLDocumentTemplate;
import org.eclipse.jnosql.mapping.metadata.EntitiesMetadata;

@ApplicationScoped
public class DocumentTemplateProducer {
    @Inject
    private DocumentEntityConverter converter;
    @Inject
    private DocumentEventPersistManager persistManager;
    @Inject
    private EntitiesMetadata entities;
    @Inject
    private Converters converters;

    public JNoSQLDocumentTemplate get(DocumentManager manager) {
        Objects.requireNonNull(manager, "manager is required");
        return new ProducerDocumentTemplate(this.converter, manager, this.persistManager, this.entities, this.converters);
    }

    @Vetoed
    static class ProducerDocumentTemplate
    extends AbstractDocumentTemplate {
        private DocumentEntityConverter converter;
        private DocumentManager manager;
        private DocumentEventPersistManager persistManager;
        private Converters converters;
        private EntitiesMetadata entities;

        ProducerDocumentTemplate(DocumentEntityConverter converter, DocumentManager manager, DocumentEventPersistManager persistManager, EntitiesMetadata entities, Converters converters) {
            this.converter = converter;
            this.manager = manager;
            this.persistManager = persistManager;
            this.entities = entities;
            this.converters = converters;
        }

        ProducerDocumentTemplate() {
        }

        @Override
        protected DocumentEntityConverter getConverter() {
            return this.converter;
        }

        @Override
        protected DocumentManager getManager() {
            return this.manager;
        }

        @Override
        protected DocumentEventPersistManager getEventManager() {
            return this.persistManager;
        }

        @Override
        protected EntitiesMetadata getEntities() {
            return this.entities;
        }

        @Override
        protected Converters getConverters() {
            return this.converters;
        }
    }
}

