/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jnosql.mapping.document;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import org.eclipse.jnosql.communication.document.Document;
import org.eclipse.jnosql.mapping.AttributeConverter;
import org.eclipse.jnosql.mapping.core.Converters;
import org.eclipse.jnosql.mapping.document.DocumentEntityConverter;
import org.eclipse.jnosql.mapping.document.DocumentFieldValue;
import org.eclipse.jnosql.mapping.metadata.DefaultFieldValue;
import org.eclipse.jnosql.mapping.metadata.FieldMetadata;
import org.eclipse.jnosql.mapping.metadata.FieldParameterMetadata;
import org.eclipse.jnosql.mapping.metadata.FieldValue;
import org.eclipse.jnosql.mapping.metadata.GenericFieldMetadata;
import org.eclipse.jnosql.mapping.metadata.MappingType;

final class DefaultDocumentFieldValue
implements DocumentFieldValue {
    private final FieldValue fieldValue;

    private DefaultDocumentFieldValue(FieldValue fieldValue) {
        this.fieldValue = fieldValue;
    }

    public Object value() {
        return this.fieldValue.value();
    }

    public FieldMetadata field() {
        return this.fieldValue.field();
    }

    @Override
    public <X, Y> List<Document> toDocument(DocumentEntityConverter converter, Converters converters) {
        if (this.value() == null) {
            return Collections.singletonList(Document.of((String)this.getName(), null));
        }
        if (MappingType.EMBEDDED.equals((Object)this.getType())) {
            return converter.toDocument(this.value()).documents();
        }
        if (MappingType.ENTITY.equals((Object)this.getType())) {
            return Collections.singletonList(Document.of((String)this.getName(), (Object)converter.toDocument(this.value()).documents()));
        }
        if (this.isEmbeddableCollection()) {
            return Collections.singletonList(Document.of((String)this.getName(), this.getDocuments(converter)));
        }
        Optional optionalConverter = this.field().converter();
        if (optionalConverter.isPresent()) {
            AttributeConverter attributeConverter = converters.get((FieldParameterMetadata)this.field());
            return Collections.singletonList(Document.of((String)this.getName(), (Object)attributeConverter.convertToDatabaseColumn(this.value())));
        }
        return Collections.singletonList(Document.of((String)this.getName(), (Object)this.value()));
    }

    private List<List<Document>> getDocuments(DocumentEntityConverter converter) {
        ArrayList<List<Document>> documents = new ArrayList<List<Document>>();
        for (Object element : (Iterable)this.value()) {
            documents.add(converter.toDocument(element).documents());
        }
        return documents;
    }

    private boolean isEmbeddableCollection() {
        return MappingType.COLLECTION.equals((Object)this.getType()) && this.isEmbeddableElement();
    }

    public boolean isNotEmpty() {
        return this.fieldValue.isNotEmpty();
    }

    private MappingType getType() {
        return this.field().mappingType();
    }

    private boolean isEmbeddableElement() {
        return ((GenericFieldMetadata)this.field()).isEmbeddable();
    }

    private String getName() {
        return this.field().name();
    }

    static DocumentFieldValue of(Object value, FieldMetadata field) {
        return new DefaultDocumentFieldValue((FieldValue)new DefaultFieldValue(value, field));
    }

    public String toString() {
        return "DocumentFieldValue{fieldValue=" + this.fieldValue + "}";
    }
}

