/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jnosql.mapping.document.query;

import jakarta.data.repository.PageableRepository;
import jakarta.enterprise.context.ApplicationScoped;
import jakarta.inject.Inject;
import java.lang.reflect.Proxy;
import java.util.Objects;
import org.eclipse.jnosql.communication.document.DocumentManager;
import org.eclipse.jnosql.mapping.Converters;
import org.eclipse.jnosql.mapping.document.DocumentTemplateProducer;
import org.eclipse.jnosql.mapping.document.JNoSQLDocumentTemplate;
import org.eclipse.jnosql.mapping.document.query.DocumentRepositoryProxy;
import org.eclipse.jnosql.mapping.metadata.EntitiesMetadata;

@ApplicationScoped
public class DocumentRepositoryProducer {
    @Inject
    private EntitiesMetadata entities;
    @Inject
    private Converters converters;
    @Inject
    private DocumentTemplateProducer producer;

    public <T, K, R extends PageableRepository<T, K>> R get(Class<R> repositoryClass, DocumentManager manager) {
        Objects.requireNonNull(repositoryClass, "repository class is required");
        Objects.requireNonNull(manager, "manager class is required");
        JNoSQLDocumentTemplate template = this.producer.get(manager);
        return this.get(repositoryClass, template);
    }

    public <T, K, R extends PageableRepository<T, K>> R get(Class<R> repositoryClass, JNoSQLDocumentTemplate template) {
        Objects.requireNonNull(repositoryClass, "repository class is required");
        Objects.requireNonNull(template, "template class is required");
        DocumentRepositoryProxy handler = new DocumentRepositoryProxy(template, this.entities, repositoryClass, this.converters);
        return (R)((PageableRepository)Proxy.newProxyInstance(repositoryClass.getClassLoader(), new Class[]{repositoryClass}, handler));
    }
}

