/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jnosql.mapping.document;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import org.eclipse.jnosql.communication.TypeReference;
import org.eclipse.jnosql.communication.TypeSupplier;
import org.eclipse.jnosql.communication.Value;
import org.eclipse.jnosql.communication.document.Document;
import org.eclipse.jnosql.mapping.AttributeConverter;
import org.eclipse.jnosql.mapping.document.DocumentEntityConverter;
import org.eclipse.jnosql.mapping.metadata.EntityMetadata;
import org.eclipse.jnosql.mapping.metadata.FieldMetadata;
import org.eclipse.jnosql.mapping.metadata.FieldParameterMetadata;
import org.eclipse.jnosql.mapping.metadata.GenericFieldMetadata;
import org.eclipse.jnosql.mapping.metadata.MappingType;

/*
 * Uses 'sealed' constructs - enablewith --sealed true
 */
enum FieldConverter {
    EMBEDDED{

        @Override
        public <X, Y, T> void convert(T instance, List<Document> documents, Document document, FieldMetadata field, DocumentEntityConverter converter) {
            Object subEntity = converter.toEntity(field.type(), documents);
            EntityMetadata mapping = converter.getEntities().get(subEntity.getClass());
            boolean areAllFieldsNull = mapping.fields().stream().map(f -> f.read(subEntity)).allMatch(Objects::isNull);
            if (!areAllFieldsNull) {
                field.write(instance, subEntity);
            }
        }
    }
    ,
    ENTITY{

        @Override
        public <X, Y, T> void convert(T instance, List<Document> documents, Document document, FieldMetadata field, DocumentEntityConverter converter) {
            if (Objects.nonNull(document)) {
                this.converterSubDocument(instance, document, field, converter);
            } else {
                field.write(instance, converter.toEntity(field.type(), documents));
            }
        }

        private <T> void converterSubDocument(T instance, Document sudDocument, FieldMetadata field, DocumentEntityConverter converter) {
            Object value = sudDocument.get();
            if (value instanceof Map) {
                Map map = (Map)value;
                ArrayList<Document> embeddedDocument = new ArrayList<Document>();
                for (Map.Entry entry : map.entrySet()) {
                    embeddedDocument.add(Document.of((String)entry.getKey().toString(), entry.getValue()));
                }
                field.write(instance, converter.toEntity(field.type(), embeddedDocument));
            } else {
                field.write(instance, converter.toEntity(field.type(), (List)sudDocument.get((TypeSupplier)new TypeReference<List<Document>>(){})));
            }
        }
    }
    ,
    COLLECTION{

        @Override
        public <X, Y, T> void convert(T instance, List<Document> documents, Document document, FieldMetadata field, DocumentEntityConverter converter) {
            if (Objects.nonNull(document)) {
                GenericFieldMetadata genericField = (GenericFieldMetadata)field;
                Collection collection = genericField.collectionInstance();
                List embeddable = (List)document.get();
                for (List documentList : embeddable) {
                    Object element = converter.toEntity(genericField.elementType(), documentList);
                    collection.add(element);
                }
                field.write(instance, (Object)collection);
            }
        }
    }
    ,
    DEFAULT{

        @Override
        public <X, Y, T> void convert(T instance, List<Document> documents, Document document, FieldMetadata field, DocumentEntityConverter converter) {
            if (Objects.nonNull(document)) {
                Value value = document.value();
                Optional optionalConverter = field.converter();
                if (optionalConverter.isPresent()) {
                    AttributeConverter attributeConverter = converter.getConverters().get((FieldParameterMetadata)field);
                    Object attr = value.isInstanceOf(List.class) ? document : value.get();
                    Object attributeConverted = attributeConverter.convertToEntityAttribute(attr);
                    field.write(instance, field.value(Value.of((Object)attributeConverted)));
                } else {
                    field.write(instance, field.value(value));
                }
            }
        }
    };


    abstract <X, Y, T> void convert(T var1, List<Document> var2, Document var3, FieldMetadata var4, DocumentEntityConverter var5);

    <X, Y, T> void convert(T instance, Document document, FieldMetadata field, DocumentEntityConverter converter) {
        this.convert(instance, null, document, field, converter);
    }

    static FieldConverter get(FieldMetadata field) {
        if (MappingType.EMBEDDED.equals((Object)field.mappingType())) {
            return EMBEDDED;
        }
        if (MappingType.ENTITY.equals((Object)field.mappingType())) {
            return ENTITY;
        }
        if (FieldConverter.isCollectionEmbeddable(field)) {
            return COLLECTION;
        }
        return DEFAULT;
    }

    private static boolean isCollectionEmbeddable(FieldMetadata field) {
        return MappingType.COLLECTION.equals((Object)field.mappingType()) && ((GenericFieldMetadata)field).isEmbeddable();
    }
}

