/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jnosql.mapping.document.spi;

import jakarta.enterprise.context.spi.CreationalContext;
import jakarta.nosql.document.DocumentTemplate;
import java.lang.annotation.Annotation;
import java.lang.reflect.Type;
import java.util.Collections;
import java.util.Set;
import org.eclipse.jnosql.communication.document.DocumentManager;
import org.eclipse.jnosql.mapping.DatabaseQualifier;
import org.eclipse.jnosql.mapping.DatabaseType;
import org.eclipse.jnosql.mapping.document.DocumentTemplateProducer;
import org.eclipse.jnosql.mapping.document.JNoSQLDocumentTemplate;
import org.eclipse.jnosql.mapping.spi.AbstractBean;

class TemplateBean
extends AbstractBean<JNoSQLDocumentTemplate> {
    private static final Set<Type> TYPES = Set.of(DocumentTemplate.class, JNoSQLDocumentTemplate.class);
    private final String provider;
    private final Set<Annotation> qualifiers;

    public TemplateBean(String provider) {
        this.provider = provider;
        this.qualifiers = Collections.singleton(DatabaseQualifier.ofDocument((String)provider));
    }

    public Class<?> getBeanClass() {
        return DocumentTemplate.class;
    }

    public JNoSQLDocumentTemplate create(CreationalContext<JNoSQLDocumentTemplate> context) {
        DocumentTemplateProducer producer = (DocumentTemplateProducer)this.getInstance(DocumentTemplateProducer.class);
        DocumentManager manager = this.getManager();
        return producer.get(manager);
    }

    private DocumentManager getManager() {
        return (DocumentManager)this.getInstance(DocumentManager.class, (Annotation)DatabaseQualifier.ofDocument((String)this.provider));
    }

    public Set<Type> getTypes() {
        return TYPES;
    }

    public Set<Annotation> getQualifiers() {
        return this.qualifiers;
    }

    public String getId() {
        return DocumentTemplate.class.getName() + DatabaseType.DOCUMENT + "-" + this.provider;
    }
}

