/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jnosql.mapping.document.spi;

import jakarta.enterprise.event.Observes;
import jakarta.enterprise.inject.spi.AfterBeanDiscovery;
import jakarta.enterprise.inject.spi.Bean;
import jakarta.enterprise.inject.spi.Extension;
import jakarta.enterprise.inject.spi.ProcessProducer;
import java.util.HashSet;
import java.util.Set;
import java.util.logging.Logger;
import org.eclipse.jnosql.communication.document.DocumentManager;
import org.eclipse.jnosql.mapping.DatabaseMetadata;
import org.eclipse.jnosql.mapping.DatabaseType;
import org.eclipse.jnosql.mapping.Databases;
import org.eclipse.jnosql.mapping.document.query.RepositoryDocumentBean;
import org.eclipse.jnosql.mapping.document.spi.TemplateBean;
import org.eclipse.jnosql.mapping.reflection.ClassScanner;

public class DocumentExtension
implements Extension {
    private static final Logger LOGGER = Logger.getLogger(DocumentExtension.class.getName());
    private final Set<DatabaseMetadata> databases = new HashSet<DatabaseMetadata>();

    <T, X extends DocumentManager> void observes(@Observes ProcessProducer<T, X> pp) {
        Databases.addDatabase(pp, (DatabaseType)DatabaseType.DOCUMENT, this.databases);
    }

    void onAfterBeanDiscovery(@Observes AfterBeanDiscovery afterBeanDiscovery) {
        ClassScanner scanner = ClassScanner.INSTANCE;
        Set crudTypes = scanner.repositoriesStandard();
        LOGGER.info(String.format("Processing Document extension: %d databases crud %d found", this.databases.size(), crudTypes.size()));
        LOGGER.info("Processing repositories as a Document implementation: " + crudTypes);
        this.databases.forEach(type -> {
            TemplateBean bean = new TemplateBean(type.getProvider());
            afterBeanDiscovery.addBean((Bean)bean);
        });
        crudTypes.forEach(type -> {
            if (!this.databases.contains(DatabaseMetadata.DEFAULT_DOCUMENT)) {
                afterBeanDiscovery.addBean(new RepositoryDocumentBean((Class)type, ""));
            }
            this.databases.forEach(database -> {
                RepositoryDocumentBean bean = new RepositoryDocumentBean((Class)type, database.getProvider());
                afterBeanDiscovery.addBean(bean);
            });
        });
    }
}

