/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jnosql.mapping.document;

import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import org.eclipse.jnosql.communication.document.DocumentCondition;
import org.eclipse.jnosql.communication.document.DocumentDeleteQuery;

class MappingDocumentDeleteQuery
implements DocumentDeleteQuery {
    private final String documentCollection;
    private final DocumentCondition condition;

    MappingDocumentDeleteQuery(String documentCollection, DocumentCondition condition) {
        this.documentCollection = documentCollection;
        this.condition = condition;
    }

    public String name() {
        return this.documentCollection;
    }

    public Optional<DocumentCondition> condition() {
        return Optional.ofNullable(this.condition);
    }

    public List<String> documents() {
        return Collections.emptyList();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof DocumentDeleteQuery)) {
            return false;
        }
        DocumentDeleteQuery that = (DocumentDeleteQuery)o;
        return Objects.equals(this.documentCollection, that.name()) && Objects.equals(this.condition, that.condition().orElse(null)) && Objects.equals(Collections.emptyList(), that.documents());
    }

    public int hashCode() {
        return Objects.hash(this.documentCollection, this.condition, Collections.emptyList());
    }

    public String toString() {
        return "ArtemisDocumentDeleteQuery{documentCollection='" + this.documentCollection + "', condition=" + this.condition + ", documents=" + Collections.emptyList() + "}";
    }
}

