/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jnosql.mapping.document.query;

import jakarta.data.repository.Page;
import jakarta.data.repository.Pageable;
import jakarta.data.repository.PageableRepository;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import org.eclipse.jnosql.mapping.IdNotFoundException;
import org.eclipse.jnosql.mapping.NoSQLPage;
import org.eclipse.jnosql.mapping.document.JNoSQLDocumentTemplate;
import org.eclipse.jnosql.mapping.document.MappingDocumentQuery;
import org.eclipse.jnosql.mapping.reflection.EntityMetadata;
import org.eclipse.jnosql.mapping.reflection.FieldMapping;

public abstract class AbstractDocumentRepository<T, K>
implements PageableRepository<T, K> {
    protected abstract JNoSQLDocumentTemplate getTemplate();

    protected abstract EntityMetadata getEntityMetadata();

    public <S extends T> S save(S entity) {
        Objects.requireNonNull(entity, "Entity is required");
        Object id = this.getIdField().read(entity);
        if (Objects.nonNull(id) && this.existsById(id)) {
            return (S)this.getTemplate().update(entity);
        }
        return (S)this.getTemplate().insert(entity);
    }

    public <S extends T> Iterable<S> saveAll(Iterable<S> entities) {
        Objects.requireNonNull(entities, "entities is required");
        return StreamSupport.stream(entities.spliterator(), false).map(this::save).collect(Collectors.toList());
    }

    public void deleteById(K id) {
        Objects.requireNonNull(id, "is is required");
        this.getTemplate().delete(this.getType(), id);
    }

    public void deleteAllById(Iterable<K> ids) {
        Objects.requireNonNull(ids, "ids is required");
        ids.forEach(this::deleteById);
    }

    public Optional<T> findById(K id) {
        Objects.requireNonNull(id, "id is required");
        return this.getTemplate().find(this.getType(), id);
    }

    public Stream<T> findAllById(Iterable<K> ids) {
        Objects.requireNonNull(ids, "ids is required");
        return StreamSupport.stream(ids.spliterator(), false).flatMap(this.optionalToStream());
    }

    public long count() {
        return this.getTemplate().count(this.getType());
    }

    private FieldMapping getIdField() {
        return (FieldMapping)this.getEntityMetadata().id().orElseThrow(IdNotFoundException.KEY_NOT_FOUND_EXCEPTION_SUPPLIER);
    }

    public boolean existsById(K id) {
        return this.findById(id).isPresent();
    }

    public Page findAll(Pageable pageable) {
        Objects.requireNonNull(pageable, "pageable is required");
        EntityMetadata metadata = this.getEntityMetadata();
        MappingDocumentQuery query = new MappingDocumentQuery(pageable.sorts(), pageable.size(), NoSQLPage.skip((Pageable)pageable), null, metadata.name());
        List entities = this.getTemplate().select(query).toList();
        return NoSQLPage.of(entities, (Pageable)pageable);
    }

    public Stream findAll() {
        return this.getTemplate().findAll(this.getType());
    }

    public void delete(Object entity) {
        throw new UnsupportedOperationException("The JNoSQL Column has not support for it yet");
    }

    public void deleteAll(Iterable entities) {
        throw new UnsupportedOperationException("The JNoSQL Column has not support for it yet");
    }

    public void deleteAll() {
        this.getTemplate().deleteAll(this.getType());
    }

    private Class<T> getType() {
        return this.getEntityMetadata().type();
    }

    private Function optionalToStream() {
        return id -> {
            Optional<T> entity = this.findById(id);
            return entity.isPresent() ? Stream.of(entity.get()) : Stream.empty();
        };
    }
}

