/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jnosql.mapping.document;

import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import org.eclipse.jnosql.communication.TypeReference;
import org.eclipse.jnosql.communication.TypeSupplier;
import org.eclipse.jnosql.communication.Value;
import org.eclipse.jnosql.communication.document.Document;
import org.eclipse.jnosql.mapping.AttributeConverter;
import org.eclipse.jnosql.mapping.document.DocumentEntityConverter;
import org.eclipse.jnosql.mapping.reflection.EntityMetadata;
import org.eclipse.jnosql.mapping.reflection.FieldMapping;
import org.eclipse.jnosql.mapping.reflection.GenericFieldMapping;
import org.eclipse.jnosql.mapping.reflection.MappingType;

/*
 * Uses 'sealed' constructs - enablewith --sealed true
 */
enum FieldConverter {
    EMBEDDED{

        @Override
        public <X, Y, T> void convert(T instance, List<Document> documents, Document document, FieldMapping field, DocumentEntityConverter converter) {
            Field nativeField = field.nativeField();
            Object subEntity = converter.toEntity(nativeField.getType(), documents);
            EntityMetadata mapping = converter.getEntities().get(subEntity.getClass());
            boolean areAllFieldsNull = mapping.fields().stream().map(f -> f.read(subEntity)).allMatch(Objects::isNull);
            if (!areAllFieldsNull) {
                field.write(instance, subEntity);
            }
        }
    }
    ,
    ENTITY{

        @Override
        public <X, Y, T> void convert(T instance, List<Document> documents, Document document, FieldMapping field, DocumentEntityConverter converter) {
            if (Objects.nonNull(document)) {
                this.converterSubDocument(instance, document, field, converter);
            } else {
                field.write(instance, converter.toEntity(field.nativeField().getType(), documents));
            }
        }

        private <T> void converterSubDocument(T instance, Document sudDocument, FieldMapping field, DocumentEntityConverter converter) {
            Object value = sudDocument.get();
            if (value instanceof Map) {
                Map map = (Map)value;
                ArrayList<Document> embeddedDocument = new ArrayList<Document>();
                for (Map.Entry entry : map.entrySet()) {
                    embeddedDocument.add(Document.of((String)entry.getKey().toString(), entry.getValue()));
                }
                field.write(instance, converter.toEntity(field.nativeField().getType(), embeddedDocument));
            } else {
                field.write(instance, converter.toEntity(field.nativeField().getType(), (List)sudDocument.get((TypeSupplier)new TypeReference<List<Document>>(){})));
            }
        }
    }
    ,
    COLLECTION{

        @Override
        public <X, Y, T> void convert(T instance, List<Document> documents, Document document, FieldMapping field, DocumentEntityConverter converter) {
            if (Objects.nonNull(document)) {
                GenericFieldMapping genericField = (GenericFieldMapping)field;
                Collection collection = genericField.getCollectionInstance();
                List embeddable = (List)document.get();
                for (List documentList : embeddable) {
                    Object element = converter.toEntity(genericField.getElementType(), documentList);
                    collection.add(element);
                }
                field.write(instance, (Object)collection);
            }
        }
    }
    ,
    DEFAULT{

        @Override
        public <X, Y, T> void convert(T instance, List<Document> documents, Document document, FieldMapping field, DocumentEntityConverter converter) {
            if (Objects.nonNull(document)) {
                Value value = document.value();
                Optional optionalConverter = field.getConverter();
                if (optionalConverter.isPresent()) {
                    AttributeConverter attributeConverter = converter.getConverters().get((Class)optionalConverter.get());
                    Object attr = value.isInstanceOf(List.class) ? document : value.get();
                    Object attributeConverted = attributeConverter.convertToEntityAttribute(attr);
                    field.write(instance, field.value(Value.of((Object)attributeConverted)));
                } else {
                    field.write(instance, field.value(value));
                }
            }
        }
    };


    abstract <X, Y, T> void convert(T var1, List<Document> var2, Document var3, FieldMapping var4, DocumentEntityConverter var5);

    <X, Y, T> void convert(T instance, Document document, FieldMapping field, DocumentEntityConverter converter) {
        this.convert(instance, null, document, field, converter);
    }

    static FieldConverter get(FieldMapping field) {
        if (MappingType.EMBEDDED.equals((Object)field.type())) {
            return EMBEDDED;
        }
        if (MappingType.ENTITY.equals((Object)field.type())) {
            return ENTITY;
        }
        if (FieldConverter.isCollectionEmbeddable(field)) {
            return COLLECTION;
        }
        return DEFAULT;
    }

    private static boolean isCollectionEmbeddable(FieldMapping field) {
        return MappingType.COLLECTION.equals((Object)field.type()) && ((GenericFieldMapping)field).isEmbeddable();
    }
}

