/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jnosql.mapping.document.spi;

import jakarta.nosql.document.DocumentManager;
import jakarta.nosql.mapping.DatabaseType;
import jakarta.nosql.mapping.document.DocumentTemplate;
import jakarta.nosql.mapping.document.DocumentTemplateProducer;
import java.lang.annotation.Annotation;
import java.lang.reflect.Type;
import java.util.Collections;
import java.util.Set;
import javax.enterprise.context.ApplicationScoped;
import javax.enterprise.context.spi.CreationalContext;
import javax.enterprise.inject.spi.InjectionPoint;
import org.eclipse.jnosql.mapping.DatabaseQualifier;
import org.eclipse.jnosql.mapping.spi.AbstractBean;

class TemplateBean
extends AbstractBean<DocumentTemplate> {
    private final Set<Type> types = Collections.singleton(DocumentTemplate.class);
    private final String provider;
    private final Set<Annotation> qualifiers;

    public TemplateBean(String provider) {
        this.provider = provider;
        this.qualifiers = Collections.singleton(DatabaseQualifier.ofDocument((String)provider));
    }

    public Class<?> getBeanClass() {
        return DocumentTemplate.class;
    }

    public Set<InjectionPoint> getInjectionPoints() {
        return Collections.emptySet();
    }

    public boolean isNullable() {
        return false;
    }

    public DocumentTemplate create(CreationalContext<DocumentTemplate> context) {
        DocumentTemplateProducer producer = (DocumentTemplateProducer)this.getInstance(DocumentTemplateProducer.class);
        DocumentManager manager = this.getManager();
        return producer.get(manager);
    }

    private DocumentManager getManager() {
        return (DocumentManager)this.getInstance(DocumentManager.class, (Annotation)DatabaseQualifier.ofDocument((String)this.provider));
    }

    public void destroy(DocumentTemplate instance, CreationalContext<DocumentTemplate> creationalContext) {
    }

    public Set<Type> getTypes() {
        return this.types;
    }

    public Set<Annotation> getQualifiers() {
        return this.qualifiers;
    }

    public Class<? extends Annotation> getScope() {
        return ApplicationScoped.class;
    }

    public String getName() {
        return null;
    }

    public Set<Class<? extends Annotation>> getStereotypes() {
        return Collections.emptySet();
    }

    public boolean isAlternative() {
        return false;
    }

    public String getId() {
        return DocumentTemplate.class.getName() + DatabaseType.DOCUMENT + "-" + this.provider;
    }
}

