/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jnosql.mapping.document.query;

import jakarta.nosql.mapping.Converters;
import jakarta.nosql.mapping.DatabaseType;
import jakarta.nosql.mapping.Repository;
import jakarta.nosql.mapping.document.DocumentTemplate;
import java.lang.annotation.Annotation;
import java.lang.reflect.Proxy;
import java.lang.reflect.Type;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import javax.enterprise.context.spi.CreationalContext;
import org.eclipse.jnosql.mapping.DatabaseQualifier;
import org.eclipse.jnosql.mapping.document.query.DocumentRepositoryProxy;
import org.eclipse.jnosql.mapping.reflection.EntitiesMetadata;
import org.eclipse.jnosql.mapping.spi.AbstractBean;
import org.eclipse.jnosql.mapping.util.AnnotationLiteralUtil;

public class RepositoryDocumentBean
extends AbstractBean<Repository> {
    private final Class type;
    private final Set<Type> types;
    private final String provider;
    private final Set<Annotation> qualifiers;

    public RepositoryDocumentBean(Class type, String provider) {
        this.type = type;
        this.types = Collections.singleton(type);
        this.provider = provider;
        if (provider.isEmpty()) {
            this.qualifiers = new HashSet<Annotation>();
            this.qualifiers.add((Annotation)DatabaseQualifier.ofDocument());
            this.qualifiers.add((Annotation)AnnotationLiteralUtil.DEFAULT_ANNOTATION);
            this.qualifiers.add((Annotation)AnnotationLiteralUtil.ANY_ANNOTATION);
        } else {
            this.qualifiers = Collections.singleton(DatabaseQualifier.ofDocument((String)provider));
        }
    }

    public Class<?> getBeanClass() {
        return this.type;
    }

    public Repository create(CreationalContext<Repository> context) {
        EntitiesMetadata entities = (EntitiesMetadata)this.getInstance(EntitiesMetadata.class);
        DocumentTemplate template = this.provider.isEmpty() ? (DocumentTemplate)this.getInstance(DocumentTemplate.class) : (DocumentTemplate)this.getInstance(DocumentTemplate.class, (Annotation)DatabaseQualifier.ofDocument((String)this.provider));
        Converters converters = (Converters)this.getInstance(Converters.class);
        DocumentRepositoryProxy handler = new DocumentRepositoryProxy(template, entities, this.type, converters);
        return (Repository)Proxy.newProxyInstance(this.type.getClassLoader(), new Class[]{this.type}, handler);
    }

    public Set<Type> getTypes() {
        return this.types;
    }

    public Set<Annotation> getQualifiers() {
        return this.qualifiers;
    }

    public String getId() {
        return this.type.getName() + "@" + DatabaseType.DOCUMENT + "-" + this.provider;
    }
}

