/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jnosql.mapping.document.query;

import jakarta.nosql.Sort;
import jakarta.nosql.document.DocumentCondition;
import jakarta.nosql.document.DocumentQuery;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;

class MappingDocumentQuery
implements DocumentQuery {
    private final List<Sort> sorts;
    private final long limit;
    private final long skip;
    private final DocumentCondition condition;
    private final String documentCollection;

    MappingDocumentQuery(List<Sort> sorts, long limit, long skip, DocumentCondition condition, String documentCollection) {
        this.sorts = sorts;
        this.limit = limit;
        this.skip = skip;
        this.condition = condition;
        this.documentCollection = documentCollection;
    }

    public long getLimit() {
        return this.limit;
    }

    public long getSkip() {
        return this.skip;
    }

    public String getDocumentCollection() {
        return this.documentCollection;
    }

    public Optional<DocumentCondition> getCondition() {
        return Optional.ofNullable(this.condition);
    }

    public List<Sort> getSorts() {
        return this.sorts;
    }

    public List<String> getDocuments() {
        return Collections.emptyList();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof DocumentQuery)) {
            return false;
        }
        DocumentQuery that = (DocumentQuery)o;
        return this.limit == that.getLimit() && this.skip == that.getSkip() && Objects.equals(this.sorts, that.getSorts()) && Objects.equals(this.condition, that.getCondition().orElse(null)) && Objects.equals(this.documentCollection, that.getDocumentCollection());
    }

    public int hashCode() {
        return Objects.hash(this.limit, this.skip, this.documentCollection, this.condition, this.sorts, Collections.emptyList());
    }

    public String toString() {
        return "ArtemisDocumentQuery{limit=" + this.limit + ", skip=" + this.skip + ", documentCollection='" + this.documentCollection + "', condition=" + this.condition + ", sorts=" + this.sorts + ", documents=" + Collections.emptyList() + "}";
    }
}

