/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jnosql.mapping.document.query;

import jakarta.nosql.Sort;
import jakarta.nosql.SortType;
import jakarta.nosql.document.DocumentQuery;
import jakarta.nosql.mapping.Converters;
import jakarta.nosql.mapping.Page;
import jakarta.nosql.mapping.Pagination;
import jakarta.nosql.mapping.document.DocumentQueryMapper;
import jakarta.nosql.mapping.document.DocumentQueryPagination;
import jakarta.nosql.mapping.document.DocumentTemplate;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Stream;
import org.eclipse.jnosql.mapping.document.query.AbstractMapperQuery;
import org.eclipse.jnosql.mapping.document.query.MappingDocumentQuery;
import org.eclipse.jnosql.mapping.reflection.EntityMetadata;

class DefaultDocumentMapperSelectBuilder
extends AbstractMapperQuery
implements DocumentQueryMapper.DocumentMapperFrom,
DocumentQueryMapper.DocumentMapperLimit,
DocumentQueryMapper.DocumentMapperSkip,
DocumentQueryMapper.DocumentMapperOrder,
DocumentQueryMapper.DocumentMapperNameCondition,
DocumentQueryMapper.DocumentMapperNotCondition,
DocumentQueryMapper.DocumentMapperNameOrder,
DocumentQueryMapper.DocumentMapperWhere {
    private final List<Sort> sorts = new ArrayList<Sort>();

    DefaultDocumentMapperSelectBuilder(EntityMetadata mapping, Converters converters) {
        super(mapping, converters);
    }

    public DocumentQueryMapper.DocumentMapperNameCondition and(String name) {
        Objects.requireNonNull(name, "name is required");
        this.name = name;
        this.and = true;
        return this;
    }

    public DocumentQueryMapper.DocumentMapperNameCondition or(String name) {
        Objects.requireNonNull(name, "name is required");
        this.name = name;
        this.and = false;
        return this;
    }

    public DocumentQueryMapper.DocumentMapperNameCondition where(String name) {
        Objects.requireNonNull(name, "name is required");
        this.name = name;
        return this;
    }

    public DocumentQueryMapper.DocumentMapperSkip skip(long start) {
        this.start = start;
        return this;
    }

    public DocumentQueryMapper.DocumentMapperLimit limit(long limit) {
        this.limit = limit;
        return this;
    }

    public DocumentQueryMapper.DocumentMapperOrder orderBy(String name) {
        Objects.requireNonNull(name, "name is required");
        this.name = name;
        return this;
    }

    public DocumentQueryMapper.DocumentMapperNotCondition not() {
        this.negate = true;
        return this;
    }

    public <T> DocumentQueryMapper.DocumentMapperWhere eq(T value) {
        this.eqImpl(value);
        return this;
    }

    public DocumentQueryMapper.DocumentMapperWhere like(String value) {
        this.likeImpl(value);
        return this;
    }

    public <T> DocumentQueryMapper.DocumentMapperWhere gt(T value) {
        this.gtImpl(value);
        return this;
    }

    public <T> DocumentQueryMapper.DocumentMapperWhere gte(T value) {
        this.gteImpl(value);
        return this;
    }

    public <T> DocumentQueryMapper.DocumentMapperWhere lt(T value) {
        this.ltImpl(value);
        return this;
    }

    public <T> DocumentQueryMapper.DocumentMapperWhere lte(T value) {
        this.lteImpl(value);
        return this;
    }

    public <T> DocumentQueryMapper.DocumentMapperWhere between(T valueA, T valueB) {
        this.betweenImpl(valueA, valueB);
        return this;
    }

    public <T> DocumentQueryMapper.DocumentMapperWhere in(Iterable<T> values) {
        this.inImpl(values);
        return this;
    }

    public DocumentQueryMapper.DocumentMapperNameOrder asc() {
        this.sorts.add(Sort.of((String)this.mapping.getColumnField(this.name), (SortType)SortType.ASC));
        return this;
    }

    public DocumentQueryMapper.DocumentMapperNameOrder desc() {
        this.sorts.add(Sort.of((String)this.mapping.getColumnField(this.name), (SortType)SortType.DESC));
        return this;
    }

    public DocumentQuery build() {
        return new MappingDocumentQuery(this.sorts, this.limit, this.start, this.condition, this.documentCollection);
    }

    public DocumentQuery build(Pagination pagination) {
        Objects.requireNonNull(pagination, "pagination is required");
        return DocumentQueryPagination.of((DocumentQuery)this.build(), (Pagination)pagination);
    }

    public <T> Stream<T> getResult(DocumentTemplate template) {
        Objects.requireNonNull(template, "template is required");
        return template.select(this.build());
    }

    public <T> Optional<T> getSingleResult(DocumentTemplate template) {
        Objects.requireNonNull(template, "template is required");
        return template.singleResult(this.build());
    }

    public <T> Stream<T> getResult(DocumentTemplate template, Pagination pagination) {
        Objects.requireNonNull(template, "template is required");
        Objects.requireNonNull(pagination, "pagination is required");
        return template.select(this.build(pagination));
    }

    public <T> Optional<T> getSingleResult(DocumentTemplate template, Pagination pagination) {
        Objects.requireNonNull(template, "template is required");
        Objects.requireNonNull(pagination, "pagination is required");
        return template.singleResult(this.build(pagination));
    }

    public <T> Page<T> page(DocumentTemplate template, Pagination pagination) {
        Objects.requireNonNull(pagination, "pagination is required");
        Objects.requireNonNull(template, "template is required");
        return template.select(DocumentQueryPagination.of((DocumentQuery)this.build(), (Pagination)pagination));
    }
}

