/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jnosql.mapping.document.query;

import jakarta.nosql.Params;
import jakarta.nosql.ServiceLoaderProvider;
import jakarta.nosql.Sort;
import jakarta.nosql.document.DeleteQueryConverter;
import jakarta.nosql.document.DocumentDeleteQuery;
import jakarta.nosql.document.DocumentDeleteQueryParams;
import jakarta.nosql.document.DocumentObserverParser;
import jakarta.nosql.document.DocumentQuery;
import jakarta.nosql.document.DocumentQueryParams;
import jakarta.nosql.document.SelectQueryConverter;
import jakarta.nosql.mapping.Converters;
import jakarta.nosql.mapping.Page;
import jakarta.nosql.mapping.Pagination;
import jakarta.nosql.mapping.document.DocumentQueryPagination;
import jakarta.nosql.mapping.document.DocumentTemplate;
import jakarta.nosql.query.DeleteQuery;
import jakarta.nosql.query.SelectQuery;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.ServiceLoader;
import java.util.function.Function;
import java.util.stream.Stream;
import org.eclipse.jnosql.communication.query.method.DeleteMethodProvider;
import org.eclipse.jnosql.communication.query.method.SelectMethodProvider;
import org.eclipse.jnosql.mapping.document.query.MappingDocumentQuery;
import org.eclipse.jnosql.mapping.document.query.RepositoryDocumentObserverParser;
import org.eclipse.jnosql.mapping.reflection.EntityMetadata;
import org.eclipse.jnosql.mapping.repository.DynamicReturn;
import org.eclipse.jnosql.mapping.util.ParamsBinder;

public abstract class BaseDocumentRepository<T> {
    private DocumentObserverParser parser;
    private ParamsBinder paramsBinder;

    protected abstract Converters getConverters();

    protected abstract EntityMetadata getEntityMetadata();

    protected abstract DocumentTemplate getTemplate();

    protected DocumentQuery getQuery(Method method, Object[] args) {
        SelectMethodProvider methodProvider = SelectMethodProvider.get();
        SelectQuery selectQuery = (SelectQuery)methodProvider.apply((Object)method, (Object)this.getEntityMetadata().getName());
        SelectQueryConverter converter = (SelectQueryConverter)ServiceLoaderProvider.get(SelectQueryConverter.class, () -> ServiceLoader.load(SelectQueryConverter.class));
        DocumentQueryParams queryParams = (DocumentQueryParams)converter.apply((Object)selectQuery, (Object)this.getParser());
        DocumentQuery query = queryParams.getQuery();
        Params params = queryParams.getParams();
        this.getParamsBinder().bind(params, args, method);
        return this.getQuerySorts(args, query);
    }

    protected DocumentQuery getQuerySorts(Object[] args, DocumentQuery query) {
        List sorts = DynamicReturn.findSorts((Object[])args);
        if (!sorts.isEmpty()) {
            ArrayList<Sort> newOrders = new ArrayList<Sort>();
            newOrders.addAll(query.getSorts());
            newOrders.addAll(sorts);
            return new MappingDocumentQuery(newOrders, query.getLimit(), query.getSkip(), query.getCondition().orElse(null), query.getDocumentCollection());
        }
        return query;
    }

    protected DocumentDeleteQuery getDeleteQuery(Method method, Object[] args) {
        DeleteMethodProvider methodProvider = DeleteMethodProvider.get();
        DeleteQuery deleteQuery = (DeleteQuery)methodProvider.apply((Object)method, (Object)this.getEntityMetadata().getName());
        DeleteQueryConverter converter = (DeleteQueryConverter)ServiceLoaderProvider.get(DeleteQueryConverter.class, () -> ServiceLoader.load(DeleteQueryConverter.class));
        DocumentDeleteQueryParams queryParams = (DocumentDeleteQueryParams)converter.apply((Object)deleteQuery, (Object)this.getParser());
        DocumentDeleteQuery query = queryParams.getQuery();
        Params params = queryParams.getParams();
        this.getParamsBinder().bind(params, args, method);
        return query;
    }

    protected DocumentObserverParser getParser() {
        if (this.parser == null) {
            this.parser = new RepositoryDocumentObserverParser(this.getEntityMetadata());
        }
        return this.parser;
    }

    protected ParamsBinder getParamsBinder() {
        if (Objects.isNull(this.paramsBinder)) {
            this.paramsBinder = new ParamsBinder(this.getEntityMetadata(), this.getConverters());
        }
        return this.paramsBinder;
    }

    protected Object executeQuery(Method method, Object[] args, Class<?> typeClass, DocumentQuery query) {
        DynamicReturn dynamicReturn = DynamicReturn.builder().withClassSource(typeClass).withMethodSource(method).withResult(() -> this.getTemplate().select(query)).withSingleResult(() -> this.getTemplate().singleResult(query)).withPagination(DynamicReturn.findPagination((Object[])args)).withStreamPagination(this.listPagination(query)).withSingleResultPagination(this.getSingleResult(query)).withPage(this.getPage(query)).build();
        return dynamicReturn.execute();
    }

    protected Function<Pagination, Page<T>> getPage(DocumentQuery query) {
        return p -> this.getTemplate().select(DocumentQueryPagination.of((DocumentQuery)query, (Pagination)p));
    }

    protected Function<Pagination, Optional<T>> getSingleResult(DocumentQuery query) {
        return p -> {
            DocumentQueryPagination queryPagination = DocumentQueryPagination.of((DocumentQuery)query, (Pagination)p);
            return this.getTemplate().singleResult((DocumentQuery)queryPagination);
        };
    }

    protected Function<Pagination, Stream<T>> listPagination(DocumentQuery query) {
        return p -> {
            DocumentQueryPagination queryPagination = DocumentQueryPagination.of((DocumentQuery)query, (Pagination)p);
            return this.getTemplate().select((DocumentQuery)queryPagination);
        };
    }
}

