/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jnosql.mapping.document;

import jakarta.nosql.document.DocumentObserverParser;
import java.util.Optional;
import org.eclipse.jnosql.mapping.reflection.EntitiesMetadata;
import org.eclipse.jnosql.mapping.reflection.EntityMetadata;

final class DocumentMapperObserver
implements DocumentObserverParser {
    private final EntitiesMetadata mappings;

    DocumentMapperObserver(EntitiesMetadata mappings) {
        this.mappings = mappings;
    }

    public String fireEntity(String entity) {
        Optional<EntityMetadata> entityMetadata = this.getEntityMetadata(entity);
        return entityMetadata.map(EntityMetadata::getName).orElse(entity);
    }

    public String fireField(String entity, String field) {
        Optional<EntityMetadata> mapping = this.getEntityMetadata(entity);
        return mapping.map(c -> c.getColumnField(field)).orElse(field);
    }

    private Optional<EntityMetadata> getEntityMetadata(String entity) {
        Optional bySimpleName = this.mappings.findBySimpleName(entity);
        if (bySimpleName.isPresent()) {
            return bySimpleName;
        }
        return this.mappings.findByClassName(entity);
    }
}

