/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jnosql.mapping.document;

import jakarta.nosql.document.DocumentEntity;
import jakarta.nosql.mapping.document.DocumentEntityConverter;
import jakarta.nosql.mapping.document.DocumentEventPersistManager;
import jakarta.nosql.mapping.document.DocumentWorkflow;
import java.util.Objects;
import java.util.function.Function;
import java.util.function.UnaryOperator;

public abstract class AbstractDocumentWorkflow
implements DocumentWorkflow {
    protected abstract DocumentEventPersistManager getEventManager();

    protected abstract DocumentEntityConverter getConverter();

    public <T> T flow(T entity, UnaryOperator<DocumentEntity> action) {
        Function<T, T> flow = this.getFlow(entity, action);
        return flow.apply(entity);
    }

    private <T> Function<T, T> getFlow(T entity, UnaryOperator<DocumentEntity> action) {
        UnaryOperator validation = t -> Objects.requireNonNull(t, "entity is required");
        UnaryOperator firePreEntity = t -> {
            this.getEventManager().firePreEntity(t);
            return t;
        };
        UnaryOperator firePreDocumentEntity = t -> {
            this.getEventManager().firePreDocumentEntity(t);
            return t;
        };
        Function<Object, DocumentEntity> converterDocument = t -> this.getConverter().toDocument(t);
        UnaryOperator firePreDocument = t -> {
            this.getEventManager().firePreDocument(t);
            return t;
        };
        UnaryOperator firePostDocument = t -> {
            this.getEventManager().firePostDocument(t);
            return t;
        };
        Function<DocumentEntity, Object> converterEntity = t -> this.getConverter().toEntity(entity, t);
        UnaryOperator firePostEntity = t -> {
            this.getEventManager().firePostEntity(t);
            return t;
        };
        UnaryOperator firePostDocumentEntity = t -> {
            this.getEventManager().firePostDocumentEntity(t);
            return t;
        };
        return validation.andThen(firePreEntity).andThen(firePreDocumentEntity).andThen(converterDocument).andThen(firePreDocument).andThen(action).andThen(firePostDocument).andThen(converterEntity).andThen(firePostEntity).andThen(firePostDocumentEntity);
    }
}

