/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jnosql.mapping.document;

import jakarta.nosql.NonUniqueResultException;
import jakarta.nosql.ServiceLoaderProvider;
import jakarta.nosql.document.DocumentDeleteQuery;
import jakarta.nosql.document.DocumentEntity;
import jakarta.nosql.document.DocumentManager;
import jakarta.nosql.document.DocumentObserverParser;
import jakarta.nosql.document.DocumentQuery;
import jakarta.nosql.document.DocumentQueryParser;
import jakarta.nosql.mapping.Converters;
import jakarta.nosql.mapping.IdNotFoundException;
import jakarta.nosql.mapping.Page;
import jakarta.nosql.mapping.PreparedStatement;
import jakarta.nosql.mapping.document.DocumentEntityConverter;
import jakarta.nosql.mapping.document.DocumentEventPersistManager;
import jakarta.nosql.mapping.document.DocumentQueryPagination;
import jakarta.nosql.mapping.document.DocumentTemplate;
import jakarta.nosql.mapping.document.DocumentWorkflow;
import java.time.Duration;
import java.util.Iterator;
import java.util.Objects;
import java.util.Optional;
import java.util.ServiceLoader;
import java.util.function.Function;
import java.util.function.UnaryOperator;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import org.eclipse.jnosql.mapping.document.DocumentMapperObserver;
import org.eclipse.jnosql.mapping.document.DocumentPage;
import org.eclipse.jnosql.mapping.document.DocumentPreparedStatement;
import org.eclipse.jnosql.mapping.reflection.EntitiesMetadata;
import org.eclipse.jnosql.mapping.reflection.EntityMetadata;
import org.eclipse.jnosql.mapping.reflection.FieldMapping;
import org.eclipse.jnosql.mapping.util.ConverterUtil;

public abstract class AbstractDocumentTemplate
implements DocumentTemplate {
    private static final DocumentQueryParser PARSER = (DocumentQueryParser)ServiceLoaderProvider.get(DocumentQueryParser.class, () -> ServiceLoader.load(DocumentQueryParser.class));
    private final UnaryOperator<DocumentEntity> insert = e -> this.getManager().insert(e);
    private final UnaryOperator<DocumentEntity> update = e -> this.getManager().update(e);
    private DocumentObserverParser columnQueryParser;

    protected abstract DocumentEntityConverter getConverter();

    protected abstract DocumentManager getManager();

    protected abstract DocumentWorkflow getWorkflow();

    protected abstract DocumentEventPersistManager getEventManager();

    protected abstract EntitiesMetadata getEntities();

    protected abstract Converters getConverters();

    private DocumentObserverParser getObserver() {
        if (Objects.isNull(this.columnQueryParser)) {
            this.columnQueryParser = new DocumentMapperObserver(this.getEntities());
        }
        return this.columnQueryParser;
    }

    public <T> T insert(T entity) {
        Objects.requireNonNull(entity, "entity is required");
        return (T)this.getWorkflow().flow(entity, this.insert);
    }

    public <T> T insert(T entity, Duration ttl) {
        Objects.requireNonNull(entity, "entity is required");
        Objects.requireNonNull(ttl, "ttl is required");
        return (T)this.getWorkflow().flow(entity, e -> this.getManager().insert(e, ttl));
    }

    public <T> Iterable<T> insert(Iterable<T> entities) {
        Objects.requireNonNull(entities, "entity is required");
        return StreamSupport.stream(entities.spliterator(), false).map(this::insert).collect(Collectors.toList());
    }

    public <T> Iterable<T> insert(Iterable<T> entities, Duration ttl) {
        Objects.requireNonNull(entities, "entities is required");
        Objects.requireNonNull(ttl, "ttl is required");
        return StreamSupport.stream(entities.spliterator(), false).map(e -> this.insert(e, ttl)).collect(Collectors.toList());
    }

    public <T> T update(T entity) {
        Objects.requireNonNull(entity, "entity is required");
        return (T)this.getWorkflow().flow(entity, this.update);
    }

    public <T> Iterable<T> update(Iterable<T> entities) {
        Objects.requireNonNull(entities, "entity is required");
        return StreamSupport.stream(entities.spliterator(), false).map(this::update).collect(Collectors.toList());
    }

    public void delete(DocumentDeleteQuery query) {
        Objects.requireNonNull(query, "query is required");
        this.getEventManager().firePreDeleteQuery(query);
        this.getManager().delete(query);
    }

    public <T> Stream<T> select(DocumentQuery query) {
        Objects.requireNonNull(query, "query is required");
        return this.executeQuery(query);
    }

    public <T> Page<T> select(DocumentQueryPagination query) {
        Objects.requireNonNull(query, "query is required");
        Stream<T> entities = this.executeQuery((DocumentQuery)query);
        return new DocumentPage<T>(this, entities, query);
    }

    public <T> Optional<T> singleResult(DocumentQuery query) {
        Objects.requireNonNull(query, "query is required");
        Stream<T> entities = this.select(query);
        Iterator iterator = entities.iterator();
        if (!iterator.hasNext()) {
            return Optional.empty();
        }
        Object entity = iterator.next();
        if (!iterator.hasNext()) {
            return Optional.of(entity);
        }
        throw new NonUniqueResultException("No unique result found to the query: " + query);
    }

    public <T, K> Optional<T> find(Class<T> type, K id) {
        Objects.requireNonNull(type, "type is required");
        Objects.requireNonNull(id, "id is required");
        EntityMetadata entityMetadata = this.getEntities().get(type);
        FieldMapping idField = (FieldMapping)entityMetadata.getId().orElseThrow(() -> IdNotFoundException.newInstance((Class)type));
        Object value = ConverterUtil.getValue(id, (EntityMetadata)entityMetadata, (String)idField.getFieldName(), (Converters)this.getConverters());
        DocumentQuery query = DocumentQuery.select().from(entityMetadata.getName()).where(idField.getName()).eq(value).build();
        return this.singleResult(query);
    }

    public <T, K> void delete(Class<T> type, K id) {
        Objects.requireNonNull(type, "type is required");
        Objects.requireNonNull(id, "id is required");
        EntityMetadata entityMetadata = this.getEntities().get(type);
        FieldMapping idField = (FieldMapping)entityMetadata.getId().orElseThrow(() -> IdNotFoundException.newInstance((Class)type));
        Object value = ConverterUtil.getValue(id, (EntityMetadata)entityMetadata, (String)idField.getFieldName(), (Converters)this.getConverters());
        DocumentDeleteQuery query = DocumentDeleteQuery.delete().from(entityMetadata.getName()).where(idField.getName()).eq(value).build();
        this.delete(query);
    }

    public <T> Stream<T> query(String query) {
        Objects.requireNonNull(query, "query is required");
        return PARSER.query(query, this.getManager(), this.getObserver()).map(c -> this.getConverter().toEntity(c));
    }

    public <T> Optional<T> singleResult(String query) {
        Objects.requireNonNull(query, "query is required");
        Stream<T> entities = this.query(query);
        Iterator iterator = entities.iterator();
        if (!iterator.hasNext()) {
            return Optional.empty();
        }
        Object entity = iterator.next();
        if (!iterator.hasNext()) {
            return Optional.of(entity);
        }
        throw new NonUniqueResultException("No unique result found to the query: " + query);
    }

    public PreparedStatement prepare(String query) {
        return new DocumentPreparedStatement(PARSER.prepare(query, this.getManager(), this.getObserver()), this.getConverter());
    }

    public long count(String documentCollection) {
        return this.getManager().count(documentCollection);
    }

    public <T> long count(Class<T> type) {
        Objects.requireNonNull(type, "type is required");
        EntityMetadata entityMetadata = this.getEntities().get(type);
        return this.getManager().count(entityMetadata.getName());
    }

    private <T> Stream<T> executeQuery(DocumentQuery query) {
        Objects.requireNonNull(query, "query is required");
        this.getEventManager().firePreQuery(query);
        Stream entities = this.getManager().select(query);
        Function<DocumentEntity, Object> function = e -> this.getConverter().toEntity(e);
        return entities.map(function).peek(arg_0 -> ((DocumentEventPersistManager)this.getEventManager()).firePostEntity(arg_0));
    }
}

