/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jnosql.mapping.document;

import jakarta.nosql.document.Document;
import jakarta.nosql.document.DocumentEntity;
import jakarta.nosql.mapping.Converters;
import jakarta.nosql.mapping.MappingException;
import jakarta.nosql.mapping.document.DocumentEntityConverter;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import org.eclipse.jnosql.mapping.document.DefaultDocumentFieldValue;
import org.eclipse.jnosql.mapping.document.DocumentFieldValue;
import org.eclipse.jnosql.mapping.document.FieldConverter;
import org.eclipse.jnosql.mapping.document.ParameterConverter;
import org.eclipse.jnosql.mapping.reflection.ConstructorBuilder;
import org.eclipse.jnosql.mapping.reflection.ConstructorMetadata;
import org.eclipse.jnosql.mapping.reflection.EntitiesMetadata;
import org.eclipse.jnosql.mapping.reflection.EntityMetadata;
import org.eclipse.jnosql.mapping.reflection.FieldMapping;
import org.eclipse.jnosql.mapping.reflection.FieldValue;
import org.eclipse.jnosql.mapping.reflection.InheritanceMetadata;
import org.eclipse.jnosql.mapping.reflection.MappingType;
import org.eclipse.jnosql.mapping.reflection.ParameterMetaData;

public abstract class AbstractDocumentEntityConverter
implements DocumentEntityConverter {
    protected abstract EntitiesMetadata getEntities();

    protected abstract Converters getConverters();

    public DocumentEntity toDocument(Object entity) {
        Objects.requireNonNull(entity, "entity is required");
        EntityMetadata mapping = this.getEntities().get(entity.getClass());
        DocumentEntity communication = DocumentEntity.of((String)mapping.getName());
        mapping.getFields().stream().map(f -> this.to((FieldMapping)f, entity)).filter(FieldValue::isNotEmpty).map(f -> f.toDocument(this, this.getConverters())).flatMap(Collection::stream).forEach(arg_0 -> ((DocumentEntity)communication).add(arg_0));
        mapping.getInheritance().ifPresent(i -> communication.add(i.getDiscriminatorColumn(), (Object)i.getDiscriminatorValue()));
        return communication;
    }

    public <T> T toEntity(Class<T> type, DocumentEntity entity) {
        Objects.requireNonNull(entity, "entity is required");
        Objects.requireNonNull(type, "type is required");
        return this.toEntity(type, entity.getDocuments());
    }

    public <T> T toEntity(T type, DocumentEntity entity) {
        Objects.requireNonNull(entity, "entity is required");
        Objects.requireNonNull(type, "type is required");
        EntityMetadata mapping = this.getEntities().get(type.getClass());
        return this.convertEntity(entity.getDocuments(), mapping, type);
    }

    protected <T> T toEntity(Class<T> type, List<Document> documents) {
        EntityMetadata mapping = this.getEntities().get(type);
        if (mapping.isInheritance()) {
            return this.inheritanceToEntity(documents, mapping);
        }
        ConstructorMetadata constructor = mapping.getConstructor();
        if (constructor.isDefault()) {
            Object instance = mapping.newInstance();
            return (T)this.convertEntity(documents, mapping, instance);
        }
        return this.convertEntityByConstructor(documents, mapping);
    }

    public <T> T toEntity(DocumentEntity entity) {
        Objects.requireNonNull(entity, "entity is required");
        EntityMetadata mapping = this.getEntities().findByName(entity.getName());
        if (mapping.isInheritance()) {
            return this.mapInheritanceEntity(entity, mapping.getType());
        }
        ConstructorMetadata constructor = mapping.getConstructor();
        if (constructor.isDefault()) {
            Object instance = mapping.newInstance();
            return (T)this.convertEntity(entity.getDocuments(), mapping, instance);
        }
        return this.convertEntityByConstructor(entity.getDocuments(), mapping);
    }

    protected <T> Consumer<String> feedObject(T entity, List<Document> documents, Map<String, FieldMapping> fieldsGroupByName) {
        return k -> {
            Optional<Document> document = documents.stream().filter(c -> c.getName().equals(k)).findFirst();
            FieldMapping field = (FieldMapping)fieldsGroupByName.get(k);
            FieldConverter fieldConverter = FieldConverter.get(field);
            if (MappingType.ENTITY.equals((Object)field.getType())) {
                document.ifPresent(d -> fieldConverter.convert(entity, null, (Document)d, field, this));
            } else {
                fieldConverter.convert(entity, documents, document.orElse(null), field, this);
            }
        };
    }

    private <T> T convertEntityByConstructor(List<Document> documents, EntityMetadata mapping) {
        ConstructorBuilder builder = ConstructorBuilder.of((ConstructorMetadata)mapping.getConstructor());
        for (ParameterMetaData parameter : builder.getParameters()) {
            Optional<Document> document = documents.stream().filter(c -> c.getName().equals(parameter.getName())).findFirst();
            document.ifPresentOrElse(c -> {
                ParameterConverter converter = ParameterConverter.of(parameter);
                converter.convert(this, (Document)c, parameter, builder);
            }, () -> ((ConstructorBuilder)builder).addEmptyParameter());
        }
        return (T)builder.build();
    }

    private <T> T mapInheritanceEntity(DocumentEntity entity, Class<?> type) {
        Map group = this.getEntities().findByParentGroupByDiscriminatorValue(type);
        if (group.isEmpty()) {
            throw new MappingException("There is no discriminator inheritance to the document collection " + entity.getName());
        }
        String column = group.values().stream().findFirst().map(InheritanceMetadata::getDiscriminatorColumn).orElseThrow();
        String discriminator = (String)entity.find(column, String.class).orElseThrow(() -> new MappingException("To inheritance there is the discriminator column missing on the Document Collection, the document name: " + column));
        InheritanceMetadata inheritance = Optional.ofNullable((InheritanceMetadata)group.get(discriminator)).orElseThrow(() -> new MappingException("There is no inheritance map to the discriminator column value " + discriminator));
        EntityMetadata mapping = this.getEntities().get(inheritance.getEntity());
        ConstructorMetadata constructor = mapping.getConstructor();
        if (constructor.isDefault()) {
            Object instance = mapping.newInstance();
            return (T)this.convertEntity(entity.getDocuments(), mapping, instance);
        }
        return this.convertEntityByConstructor(entity.getDocuments(), mapping);
    }

    private <T> T convertEntity(List<Document> documents, EntityMetadata mapping, T instance) {
        Map fieldsGroupByName = mapping.getFieldsGroupByName();
        List names = documents.stream().map(Document::getName).sorted().collect(Collectors.toList());
        Predicate<String> existField = k -> Collections.binarySearch(names, k) >= 0;
        Predicate<String> isElementType = k -> {
            MappingType type = ((FieldMapping)fieldsGroupByName.get(k)).getType();
            return MappingType.EMBEDDED.equals((Object)type) || MappingType.ENTITY.equals((Object)type);
        };
        fieldsGroupByName.keySet().stream().filter(existField.or(isElementType)).forEach(this.feedObject(instance, documents, fieldsGroupByName));
        return instance;
    }

    private <T> T inheritanceToEntity(List<Document> documents, EntityMetadata mapping) {
        Map group = this.getEntities().findByParentGroupByDiscriminatorValue(mapping.getType());
        if (group.isEmpty()) {
            throw new MappingException("There is no discriminator inheritance to the document collection " + mapping.getName());
        }
        String column = group.values().stream().findFirst().map(InheritanceMetadata::getDiscriminatorColumn).orElseThrow();
        String discriminator = documents.stream().filter(d -> d.getName().equals(column)).findFirst().map(d -> (String)d.get(String.class)).orElseThrow(() -> new MappingException("To inheritance there is the discriminator column missing on the Document Collection, the document name: " + column));
        InheritanceMetadata inheritance = Optional.ofNullable((InheritanceMetadata)group.get(discriminator)).orElseThrow(() -> new MappingException("There is no inheritance map to the discriminator column value " + discriminator));
        EntityMetadata inheritanceMetadata = this.getEntities().get(inheritance.getEntity());
        Object instance = inheritanceMetadata.newInstance();
        return (T)this.convertEntity(documents, inheritanceMetadata, instance);
    }

    private DocumentFieldValue to(FieldMapping field, Object entityInstance) {
        Object value = field.read(entityInstance);
        return DefaultDocumentFieldValue.of(value, field);
    }
}

