/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jnosql.databases.neo4j.mapping;

import jakarta.enterprise.context.spi.CreationalContext;
import jakarta.enterprise.inject.Default;
import jakarta.enterprise.util.AnnotationLiteral;
import java.lang.annotation.Annotation;
import java.lang.reflect.Proxy;
import java.lang.reflect.Type;
import java.util.Collections;
import java.util.Set;
import org.eclipse.jnosql.databases.neo4j.mapping.Neo4JRepository;
import org.eclipse.jnosql.databases.neo4j.mapping.Neo4JRepositoryProxy;
import org.eclipse.jnosql.databases.neo4j.mapping.Neo4JTemplate;
import org.eclipse.jnosql.mapping.core.Converters;
import org.eclipse.jnosql.mapping.core.spi.AbstractBean;
import org.eclipse.jnosql.mapping.metadata.EntitiesMetadata;

class Neo4JRepositoryBean<T, K>
extends AbstractBean<Neo4JRepository<T, K>> {
    private final Class<T> type;
    private final Set<Type> types;
    private final Set<Annotation> qualifiers = Collections.singleton(new AnnotationLiteral<Default>(){});

    Neo4JRepositoryBean(Class<T> type) {
        this.type = type;
        this.types = Collections.singleton(type);
    }

    public Class<?> getBeanClass() {
        return this.type;
    }

    public Neo4JRepository<T, K> create(CreationalContext<Neo4JRepository<T, K>> creationalContext) {
        Neo4JTemplate template = (Neo4JTemplate)this.getInstance(Neo4JTemplate.class);
        Converters converters = (Converters)this.getInstance(Converters.class);
        EntitiesMetadata entitiesMetadata = (EntitiesMetadata)this.getInstance(EntitiesMetadata.class);
        Neo4JRepositoryProxy handler = new Neo4JRepositoryProxy(template, this.type, converters, entitiesMetadata);
        return (Neo4JRepository)Proxy.newProxyInstance(this.type.getClassLoader(), new Class[]{this.type}, handler);
    }

    public Set<Type> getTypes() {
        return this.types;
    }

    public Set<Annotation> getQualifiers() {
        return this.qualifiers;
    }

    public String getId() {
        return this.type.getName() + "@neo4j";
    }
}

