/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jnosql.databases.neo4j.mapping;

import jakarta.enterprise.event.Observes;
import jakarta.enterprise.inject.spi.AfterBeanDiscovery;
import jakarta.enterprise.inject.spi.Extension;
import java.util.Set;
import java.util.logging.Logger;
import org.eclipse.jnosql.databases.neo4j.mapping.Neo4JRepository;
import org.eclipse.jnosql.databases.neo4j.mapping.Neo4JRepositoryBean;
import org.eclipse.jnosql.mapping.metadata.ClassScanner;

public class Neo4JExtension
implements Extension {
    private static final Logger LOGGER = Logger.getLogger(Neo4JExtension.class.getName());

    void onAfterBeanDiscovery(@Observes AfterBeanDiscovery afterBeanDiscovery) {
        ClassScanner scanner = ClassScanner.load();
        Set crudTypes = scanner.repositories(Neo4JRepository.class);
        LOGGER.info("Starting the onAfterBeanDiscovery with elements number: " + crudTypes.size());
        crudTypes.forEach(type -> afterBeanDiscovery.addBean(new Neo4JRepositoryBean(type)));
        LOGGER.info("Finished the onAfterBeanDiscovery");
    }
}

