/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jnosql.databases.neo4j.mapping;

import jakarta.enterprise.context.ApplicationScoped;
import jakarta.enterprise.inject.Disposes;
import jakarta.enterprise.inject.Produces;
import jakarta.enterprise.inject.Typed;
import java.util.function.Supplier;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.eclipse.jnosql.communication.Settings;
import org.eclipse.jnosql.databases.neo4j.communication.Neo4JConfiguration;
import org.eclipse.jnosql.databases.neo4j.communication.Neo4JDatabaseManager;
import org.eclipse.jnosql.databases.neo4j.communication.Neo4JDatabaseManagerFactory;
import org.eclipse.jnosql.mapping.core.config.MappingConfigurations;
import org.eclipse.jnosql.mapping.core.config.MicroProfileSettings;

@ApplicationScoped
class GraphManagerSupplier
implements Supplier<Neo4JDatabaseManager> {
    private static final String DATABASE_DEFAULT = "neo4j";
    private static final Logger LOGGER = Logger.getLogger(GraphManagerSupplier.class.getName());

    GraphManagerSupplier() {
    }

    @Override
    @Produces
    @ApplicationScoped
    @Typed(value={Neo4JDatabaseManager.class})
    public Neo4JDatabaseManager get() {
        LOGGER.fine(() -> "Creating a Neo4JDatabaseManager bean");
        MicroProfileSettings settings = MicroProfileSettings.INSTANCE;
        Neo4JConfiguration configuration = new Neo4JConfiguration();
        Neo4JDatabaseManagerFactory managerFactory = configuration.apply((Settings)settings);
        String database = (String)settings.getOrDefault((Supplier)MappingConfigurations.GRAPH_DATABASE, (Object)DATABASE_DEFAULT);
        LOGGER.fine(() -> "Creating a Neo4JDatabaseManager bean with database: " + database);
        return managerFactory.apply(database);
    }

    public void close(@Disposes Neo4JDatabaseManager manager) {
        LOGGER.log(Level.FINEST, "Closing Neo4JDatabaseManager resource, database name: " + manager.name());
        manager.close();
    }
}

