/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jnosql.databases.neo4j.communication;

import java.util.Objects;
import java.util.logging.Logger;
import org.eclipse.jnosql.communication.CommunicationException;
import org.eclipse.jnosql.communication.semistructured.DatabaseManagerFactory;
import org.eclipse.jnosql.databases.neo4j.communication.DefaultNeo4JDatabaseManager;
import org.eclipse.jnosql.databases.neo4j.communication.Neo4Property;
import org.neo4j.driver.AuthToken;
import org.neo4j.driver.AuthTokens;
import org.neo4j.driver.Driver;
import org.neo4j.driver.GraphDatabase;
import org.neo4j.driver.Result;
import org.neo4j.driver.Session;
import org.neo4j.driver.SessionConfig;

public class Neo4JDatabaseManagerFactory
implements DatabaseManagerFactory {
    private static final Logger LOGGER = Logger.getLogger(Neo4JDatabaseManagerFactory.class.getName());
    private final Driver driver;

    Neo4JDatabaseManagerFactory(Driver driver) {
        this.driver = Objects.requireNonNull(driver, "driver is required");
    }

    public void close() {
        LOGGER.info("Closing the Neo4J driver");
        this.driver.close();
    }

    public DefaultNeo4JDatabaseManager apply(String database) {
        Objects.requireNonNull(database, "database is required");
        LOGGER.fine(() -> "Creating a new instance of Neo4JDatabaseManager with the database: " + database);
        boolean databaseExists = this.databaseExists(database);
        LOGGER.fine(() -> "Database " + database + " exists: " + databaseExists);
        if (!databaseExists) {
            LOGGER.fine(() -> "Database " + database + " does not exist. Creating it...");
            this.createDatabase(database);
        }
        Session session = this.driver.session(SessionConfig.builder().withDatabase(database).build());
        return new DefaultNeo4JDatabaseManager(session, database);
    }

    static Neo4JDatabaseManagerFactory of(Neo4Property property) {
        Objects.requireNonNull(property, "property is required");
        LOGGER.fine(() -> "Creating a new instance of Neo4JDatabaseManagerFactory with the uri: " + property.uri());
        if (property.user() == null && property.password() == null) {
            LOGGER.fine("Creating a new instance of Neo4JDatabaseManagerFactory without authentication");
            return new Neo4JDatabaseManagerFactory(GraphDatabase.driver((String)property.uri()));
        }
        AuthToken basic = AuthTokens.basic((String)property.user(), (String)property.password());
        return new Neo4JDatabaseManagerFactory(GraphDatabase.driver((String)property.uri(), (AuthToken)basic));
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private boolean databaseExists(String database) {
        try (Session session = this.driver.session();){
            Result result = session.run("SHOW DATABASES");
            do {
                if (!result.hasNext()) return false;
            } while (!database.equals(result.next().get("name").asString()));
            boolean bl = true;
            return bl;
        }
        catch (Exception e) {
            LOGGER.severe("Failed to check database existence: " + e.getMessage());
        }
        return false;
    }

    private void createDatabase(String database) {
        try (Session session = this.driver.session();){
            session.run("CREATE DATABASE " + database);
            LOGGER.info("Database created: " + database);
        }
        catch (Exception e) {
            LOGGER.severe("Failed to create database: " + e.getMessage());
            throw new CommunicationException("Could not create database: " + database, (Throwable)e);
        }
    }
}

