/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jnosql.databases.mongodb.mapping;

import jakarta.data.exceptions.MappingException;
import jakarta.enterprise.context.ApplicationScoped;
import jakarta.enterprise.inject.Disposes;
import jakarta.enterprise.inject.Produces;
import jakarta.enterprise.inject.Typed;
import java.util.Optional;
import java.util.function.Supplier;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.eclipse.jnosql.communication.Settings;
import org.eclipse.jnosql.databases.mongodb.communication.MongoDBDocumentConfiguration;
import org.eclipse.jnosql.databases.mongodb.communication.MongoDBDocumentManager;
import org.eclipse.jnosql.databases.mongodb.communication.MongoDBDocumentManagerFactory;
import org.eclipse.jnosql.mapping.core.config.MappingConfigurations;
import org.eclipse.jnosql.mapping.core.config.MicroProfileSettings;

@ApplicationScoped
class DocumentManagerSupplier
implements Supplier<MongoDBDocumentManager> {
    private static final Logger LOGGER = Logger.getLogger(DocumentManagerSupplier.class.getName());

    DocumentManagerSupplier() {
    }

    @Override
    @Produces
    @Typed(value={MongoDBDocumentManager.class})
    public MongoDBDocumentManager get() {
        MicroProfileSettings settings = MicroProfileSettings.INSTANCE;
        MongoDBDocumentConfiguration configuration = new MongoDBDocumentConfiguration();
        MongoDBDocumentManagerFactory factory = configuration.apply((Settings)settings);
        Optional database = settings.get((Supplier)MappingConfigurations.DOCUMENT_DATABASE, String.class);
        String db = (String)database.orElseThrow(() -> new MappingException("Please, inform the database filling up the property " + MappingConfigurations.DOCUMENT_DATABASE));
        MongoDBDocumentManager manager = factory.apply(db);
        LOGGER.log(Level.FINEST, "Starting  a MongoDBDocumentManager instance using Eclipse MicroProfile Config, database name: " + db);
        return manager;
    }

    public void close(@Disposes MongoDBDocumentManager manager) {
        LOGGER.log(Level.FINEST, "Closing MongoDBDocumentManager resource, database name: " + manager.name());
        manager.close();
    }
}

