/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jnosql.databases.mongodb.communication;

import com.mongodb.client.AggregateIterable;
import com.mongodb.client.FindIterable;
import com.mongodb.client.MongoCollection;
import com.mongodb.client.MongoDatabase;
import com.mongodb.client.model.Projections;
import com.mongodb.client.model.Sorts;
import com.mongodb.client.result.DeleteResult;
import jakarta.data.Sort;
import java.time.Duration;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import org.bson.BsonDocument;
import org.bson.BsonValue;
import org.bson.Document;
import org.bson.conversions.Bson;
import org.eclipse.jnosql.communication.Entry;
import org.eclipse.jnosql.communication.semistructured.CommunicationEntity;
import org.eclipse.jnosql.communication.semistructured.DatabaseManager;
import org.eclipse.jnosql.communication.semistructured.DeleteQuery;
import org.eclipse.jnosql.communication.semistructured.Elements;
import org.eclipse.jnosql.communication.semistructured.SelectQuery;
import org.eclipse.jnosql.databases.mongodb.communication.DocumentQueryConversor;
import org.eclipse.jnosql.databases.mongodb.communication.MongoDBUtils;

public class MongoDBDocumentManager
implements DatabaseManager {
    private static final BsonDocument EMPTY = new BsonDocument();
    private final MongoDatabase mongoDatabase;
    private final String database;

    MongoDBDocumentManager(MongoDatabase mongoDatabase, String database) {
        this.mongoDatabase = mongoDatabase;
        this.database = database;
    }

    public String name() {
        return this.database;
    }

    public CommunicationEntity insert(CommunicationEntity entity) {
        Objects.requireNonNull(entity, "entity is required");
        String collectionName = entity.name();
        MongoCollection collection = this.mongoDatabase.getCollection(collectionName);
        Document document = MongoDBUtils.getDocument(entity);
        if (document.get((Object)"_id") == null) {
            document.remove((Object)"_id");
            entity.remove("_id");
        }
        collection.insertOne((Object)document);
        boolean hasNotId = entity.elements().stream().map(Entry::name).noneMatch(k -> k.equals("_id"));
        if (hasNotId) {
            entity.add(Elements.of((String)"_id", (Object)document.get((Object)"_id")));
        }
        return entity;
    }

    public CommunicationEntity insert(CommunicationEntity entity, Duration ttl) {
        throw new UnsupportedOperationException("MongoDB does not support save with TTL");
    }

    public Iterable<CommunicationEntity> insert(Iterable<CommunicationEntity> entities) {
        Objects.requireNonNull(entities, "entities is required");
        return StreamSupport.stream(entities.spliterator(), false).map(this::insert).toList();
    }

    public Iterable<CommunicationEntity> insert(Iterable<CommunicationEntity> entities, Duration ttl) {
        Objects.requireNonNull(entities, "entities is required");
        Objects.requireNonNull(ttl, "ttl is required");
        return StreamSupport.stream(entities.spliterator(), false).map(e -> this.insert((CommunicationEntity)e, ttl)).toList();
    }

    public CommunicationEntity update(CommunicationEntity entity) {
        Objects.requireNonNull(entity, "entity is required");
        CommunicationEntity copy = entity.copy();
        String collectionName = entity.name();
        MongoCollection collection = this.mongoDatabase.getCollection(collectionName);
        Document id = copy.find("_id").map(d -> new Document(d.name(), d.value().get())).orElseThrow(() -> new UnsupportedOperationException("To update this DocumentEntity the field `id` is required"));
        copy.remove("_id");
        collection.findOneAndReplace((Bson)id, (Object)MongoDBUtils.getDocument(entity));
        return entity;
    }

    public Iterable<CommunicationEntity> update(Iterable<CommunicationEntity> entities) {
        Objects.requireNonNull(entities, "entities is required");
        return StreamSupport.stream(entities.spliterator(), false).map(this::update).toList();
    }

    public void delete(DeleteQuery query) {
        Objects.requireNonNull(query, "query is required");
        String collectionName = query.name();
        MongoCollection collection = this.mongoDatabase.getCollection(collectionName);
        Bson mongoDBQuery = query.condition().map(DocumentQueryConversor::convert).orElse((Bson)EMPTY);
        collection.deleteMany(mongoDBQuery);
    }

    public Stream<CommunicationEntity> select(SelectQuery query) {
        Objects.requireNonNull(query, "query is required");
        String collectionName = query.name();
        MongoCollection collection = this.mongoDatabase.getCollection(collectionName);
        Bson mongoDBQuery = query.condition().map(DocumentQueryConversor::convert).orElse((Bson)EMPTY);
        FindIterable documents = collection.find(mongoDBQuery);
        documents.projection(Projections.include((List)query.columns()));
        if (query.skip() > 0L) {
            documents.skip((int)query.skip());
        }
        if (query.limit() > 0L) {
            documents.limit((int)query.limit());
        }
        query.sorts().stream().map(this::getSort).forEach(arg_0 -> ((FindIterable)documents).sort(arg_0));
        return StreamSupport.stream(documents.spliterator(), false).map(MongoDBUtils::of).map(ds -> CommunicationEntity.of((String)collectionName, (List)ds));
    }

    public long count(String documentCollection) {
        Objects.requireNonNull(documentCollection, "documentCollection is required");
        MongoCollection collection = this.mongoDatabase.getCollection(documentCollection);
        return collection.countDocuments();
    }

    public void close() {
    }

    public long delete(String collectionName, Bson filter) {
        Objects.requireNonNull(filter, "filter is required");
        Objects.requireNonNull(collectionName, "collectionName is required");
        MongoCollection collection = this.mongoDatabase.getCollection(collectionName);
        DeleteResult result = collection.deleteMany(filter);
        return result.getDeletedCount();
    }

    public Stream<Map<String, BsonValue>> aggregate(String collectionName, Bson ... pipeline) {
        Objects.requireNonNull(pipeline, "filter is required");
        Objects.requireNonNull(collectionName, "collectionName is required");
        MongoCollection collection = this.mongoDatabase.getCollection(collectionName, BsonDocument.class);
        AggregateIterable aggregate = collection.aggregate(Arrays.asList(pipeline));
        return StreamSupport.stream(aggregate.spliterator(), false);
    }

    public Stream<CommunicationEntity> aggregate(String collectionName, List<Bson> pipeline) {
        Objects.requireNonNull(pipeline, "pipeline is required");
        Objects.requireNonNull(collectionName, "collectionName is required");
        MongoCollection collection = this.mongoDatabase.getCollection(collectionName);
        AggregateIterable aggregate = collection.aggregate(pipeline);
        return StreamSupport.stream(aggregate.spliterator(), false).map(MongoDBUtils::of).map(ds -> CommunicationEntity.of((String)collectionName, (List)ds));
    }

    public Stream<CommunicationEntity> select(String collectionName, Bson filter) {
        Objects.requireNonNull(filter, "filter is required");
        Objects.requireNonNull(collectionName, "collectionName is required");
        MongoCollection collection = this.mongoDatabase.getCollection(collectionName);
        FindIterable documents = collection.find(filter);
        return StreamSupport.stream(documents.spliterator(), false).map(MongoDBUtils::of).map(ds -> CommunicationEntity.of((String)collectionName, (List)ds));
    }

    private Bson getSort(Sort<?> sort) {
        return sort.isAscending() ? Sorts.ascending((String[])new String[]{sort.property()}) : Sorts.descending((String[])new String[]{sort.property()});
    }

    public long count(String collectionName, Bson filter) {
        Objects.requireNonNull(filter, "filter is required");
        Objects.requireNonNull(collectionName, "collectionName is required");
        MongoCollection collection = this.mongoDatabase.getCollection(collectionName);
        return collection.countDocuments(filter);
    }
}

