/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jnosql.databases.mongodb.mapping;

import jakarta.enterprise.context.ApplicationScoped;
import jakarta.enterprise.inject.Instance;
import jakarta.enterprise.inject.Typed;
import jakarta.inject.Inject;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Stream;
import org.bson.BsonValue;
import org.bson.conversions.Bson;
import org.eclipse.jnosql.communication.document.DocumentEntity;
import org.eclipse.jnosql.databases.mongodb.communication.MongoDBDocumentManager;
import org.eclipse.jnosql.databases.mongodb.mapping.MongoDBTemplate;
import org.eclipse.jnosql.mapping.Converters;
import org.eclipse.jnosql.mapping.document.AbstractDocumentTemplate;
import org.eclipse.jnosql.mapping.document.DocumentEntityConverter;
import org.eclipse.jnosql.mapping.document.DocumentEventPersistManager;
import org.eclipse.jnosql.mapping.document.DocumentWorkflow;
import org.eclipse.jnosql.mapping.reflection.EntitiesMetadata;
import org.eclipse.jnosql.mapping.reflection.EntityMetadata;

@ApplicationScoped
@Typed(value={MongoDBTemplate.class})
class DefaultMongoDBTemplate
extends AbstractDocumentTemplate
implements MongoDBTemplate {
    private final Instance<MongoDBDocumentManager> manager;
    private final DocumentEntityConverter converter;
    private final DocumentWorkflow workflow;
    private final EntitiesMetadata entities;
    private final Converters converters;
    private final DocumentEventPersistManager persistManager;

    @Inject
    DefaultMongoDBTemplate(Instance<MongoDBDocumentManager> manager, DocumentEntityConverter converter, DocumentWorkflow workflow, EntitiesMetadata entities, Converters converters, DocumentEventPersistManager persistManager) {
        this.manager = manager;
        this.converter = converter;
        this.workflow = workflow;
        this.entities = entities;
        this.converters = converters;
        this.persistManager = persistManager;
    }

    protected DocumentEntityConverter getConverter() {
        return this.converter;
    }

    protected MongoDBDocumentManager getManager() {
        return (MongoDBDocumentManager)this.manager.get();
    }

    protected DocumentWorkflow getWorkflow() {
        return this.workflow;
    }

    protected DocumentEventPersistManager getEventManager() {
        return this.persistManager;
    }

    protected EntitiesMetadata getEntities() {
        return this.entities;
    }

    protected Converters getConverters() {
        return this.converters;
    }

    @Override
    public long delete(String collectionName, Bson filter) {
        Objects.requireNonNull(collectionName, "collectionName is required");
        Objects.requireNonNull(filter, "filter is required");
        return this.getManager().delete(collectionName, filter);
    }

    @Override
    public <T> long delete(Class<T> entity, Bson filter) {
        Objects.requireNonNull(entity, "Entity is required");
        Objects.requireNonNull(filter, "filter is required");
        EntityMetadata entityMetadata = this.entities.get(entity);
        return this.getManager().delete(entityMetadata.name(), filter);
    }

    @Override
    public <T> Stream<T> select(String collectionName, Bson filter) {
        Objects.requireNonNull(collectionName, "collectionName is required");
        Objects.requireNonNull(filter, "filter is required");
        Stream<DocumentEntity> entityStream = this.getManager().select(collectionName, filter);
        return entityStream.map(arg_0 -> ((DocumentEntityConverter)this.converter).toEntity(arg_0));
    }

    @Override
    public <T> Stream<T> select(Class<T> entity, Bson filter) {
        Objects.requireNonNull(entity, "entity is required");
        Objects.requireNonNull(filter, "filter is required");
        EntityMetadata entityMetadata = this.entities.get(entity);
        Stream<DocumentEntity> entityStream = this.getManager().select(entityMetadata.name(), filter);
        return entityStream.map(arg_0 -> ((DocumentEntityConverter)this.converter).toEntity(arg_0));
    }

    @Override
    public Stream<Map<String, BsonValue>> aggregate(String collectionName, List<Bson> pipeline) {
        Objects.requireNonNull(collectionName, "collectionName is required");
        Objects.requireNonNull(pipeline, "pipeline is required");
        return this.getManager().aggregate(collectionName, pipeline);
    }

    @Override
    public <T> Stream<Map<String, BsonValue>> aggregate(Class<T> entity, List<Bson> pipeline) {
        Objects.requireNonNull(entity, "entity is required");
        Objects.requireNonNull(pipeline, "pipeline is required");
        EntityMetadata entityMetadata = this.entities.get(entity);
        return this.getManager().aggregate(entityMetadata.name(), pipeline);
    }

    @Override
    public long count(String collectionName, Bson filter) {
        Objects.requireNonNull(collectionName, "collection name is required");
        Objects.requireNonNull(filter, "filter is required");
        return this.getManager().count(collectionName, filter);
    }

    @Override
    public <T> long count(Class<T> entity, Bson filter) {
        Objects.requireNonNull(entity, "entity is required");
        Objects.requireNonNull(filter, "filter is required");
        EntityMetadata entityMetadata = this.entities.get(entity);
        return this.getManager().count(entityMetadata.name(), filter);
    }
}

