/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jnosql.databases.mongodb.communication;

import com.mongodb.client.MongoClient;
import java.util.Objects;
import org.eclipse.jnosql.communication.document.DocumentManagerFactory;
import org.eclipse.jnosql.databases.mongodb.communication.MongoDBDocumentManager;

public class MongoDBDocumentManagerFactory
implements DocumentManagerFactory {
    private final MongoClient mongoClient;

    MongoDBDocumentManagerFactory(MongoClient mongoClient) {
        this.mongoClient = mongoClient;
    }

    public MongoDBDocumentManager apply(String database) {
        Objects.requireNonNull(database, "database is required");
        return new MongoDBDocumentManager(this.mongoClient.getDatabase(database), database);
    }

    public void close() {
        this.mongoClient.close();
    }

    public String toString() {
        return "MongoDBDocumentManagerFactory{mongoClient=" + this.mongoClient + "}";
    }
}

