/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jnosql.databases.mongodb.communication;

import com.mongodb.client.model.Filters;
import java.util.List;
import java.util.stream.Collectors;
import org.bson.conversions.Bson;
import org.eclipse.jnosql.communication.TypeReference;
import org.eclipse.jnosql.communication.TypeSupplier;
import org.eclipse.jnosql.communication.Value;
import org.eclipse.jnosql.communication.document.Document;
import org.eclipse.jnosql.communication.document.DocumentCondition;
import org.eclipse.jnosql.communication.driver.ValueUtil;

final class DocumentQueryConversor {
    private DocumentQueryConversor() {
    }

    public static Bson convert(DocumentCondition condition) {
        Document document = condition.document();
        Object value = ValueUtil.convert((Value)document.value());
        switch (condition.condition()) {
            case EQUALS: {
                return Filters.eq((String)document.name(), (Object)value);
            }
            case GREATER_THAN: {
                return Filters.gt((String)document.name(), (Object)value);
            }
            case GREATER_EQUALS_THAN: {
                return Filters.gte((String)document.name(), (Object)value);
            }
            case LESSER_THAN: {
                return Filters.lt((String)document.name(), (Object)value);
            }
            case LESSER_EQUALS_THAN: {
                return Filters.lte((String)document.name(), (Object)value);
            }
            case IN: {
                List inList = ValueUtil.convertToList((Value)document.value());
                return Filters.in((String)document.name(), (Object[])inList.toArray());
            }
            case NOT: {
                return Filters.not((Bson)DocumentQueryConversor.convert((DocumentCondition)document.get(DocumentCondition.class)));
            }
            case LIKE: {
                return Filters.regex((String)document.name(), (String)value.toString());
            }
            case AND: {
                List andList = (List)condition.document().value().get((TypeSupplier)new TypeReference<List<DocumentCondition>>(){});
                return Filters.and((Iterable)andList.stream().map(DocumentQueryConversor::convert).collect(Collectors.toList()));
            }
            case OR: {
                List orList = (List)condition.document().value().get((TypeSupplier)new TypeReference<List<DocumentCondition>>(){});
                return Filters.or((Iterable)orList.stream().map(DocumentQueryConversor::convert).collect(Collectors.toList()));
            }
        }
        throw new UnsupportedOperationException("The condition " + condition.condition() + " is not supported from mongoDB diana driver");
    }
}

