/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jnosql.communication.driver;

import jakarta.json.bind.Jsonb;
import java.lang.reflect.Type;
import java.util.Objects;
import org.eclipse.jnosql.communication.TypeSupplier;
import org.eclipse.jnosql.communication.Value;
import org.eclipse.jnosql.communication.driver.JsonbSupplier;

public class ValueJSON
implements Value {
    private static final Jsonb JSONB = (Jsonb)JsonbSupplier.getInstance().get();
    private final String json;

    ValueJSON(String json) {
        this.json = json;
    }

    public Object get() {
        return this.json;
    }

    public <T> T get(Class<T> clazz) throws NullPointerException, UnsupportedOperationException {
        Objects.requireNonNull(clazz, "clazz is required");
        return (T)JSONB.fromJson(this.json, clazz);
    }

    public <T> T get(TypeSupplier<T> typeSupplier) throws NullPointerException, UnsupportedOperationException {
        Objects.requireNonNull(typeSupplier, "typeSupplier is required");
        return (T)JSONB.fromJson(this.json, (Type)typeSupplier.get());
    }

    public boolean isInstanceOf(Class<?> typeClass) {
        Objects.requireNonNull(typeClass, "typeClass is requried");
        return typeClass.isInstance(this.json);
    }

    public static Value of(String json) throws NullPointerException {
        Objects.requireNonNull(json, "json is required");
        return new ValueJSON(json);
    }

    public static Value of(Object json) throws NullPointerException {
        Objects.requireNonNull(json, "json is required");
        return new ValueJSON(JSONB.toJson(json));
    }
}

