/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jnosql.databases.arangodb.mapping;

import jakarta.data.exceptions.MappingException;
import jakarta.enterprise.context.ApplicationScoped;
import jakarta.enterprise.inject.Disposes;
import jakarta.enterprise.inject.Produces;
import jakarta.enterprise.inject.Typed;
import java.util.Optional;
import java.util.function.Supplier;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.eclipse.jnosql.communication.Settings;
import org.eclipse.jnosql.databases.arangodb.communication.ArangoDBDocumentConfiguration;
import org.eclipse.jnosql.databases.arangodb.communication.ArangoDBDocumentManager;
import org.eclipse.jnosql.databases.arangodb.communication.ArangoDBDocumentManagerFactory;
import org.eclipse.jnosql.mapping.core.config.MappingConfigurations;
import org.eclipse.jnosql.mapping.core.config.MicroProfileSettings;

@ApplicationScoped
class DocumentManagerSupplier
implements Supplier<ArangoDBDocumentManager> {
    private static final Logger LOGGER = Logger.getLogger(DocumentManagerSupplier.class.getName());

    DocumentManagerSupplier() {
    }

    @Override
    @Produces
    @Typed(value={ArangoDBDocumentManager.class})
    public ArangoDBDocumentManager get() {
        MicroProfileSettings settings = MicroProfileSettings.INSTANCE;
        ArangoDBDocumentConfiguration configuration = new ArangoDBDocumentConfiguration();
        ArangoDBDocumentManagerFactory factory = configuration.apply((Settings)settings);
        Optional database = settings.get((Supplier)MappingConfigurations.DOCUMENT_DATABASE, String.class);
        String db = (String)database.orElseThrow(() -> new MappingException("Please, inform the database filling up the property " + MappingConfigurations.DOCUMENT_DATABASE.get()));
        ArangoDBDocumentManager manager = factory.apply(db);
        LOGGER.log(Level.FINEST, "Starting  a ArangoDBDocumentManager instance using Eclipse MicroProfile Config, database name: " + db);
        return manager;
    }

    public void close(@Disposes ArangoDBDocumentManager manager) {
        LOGGER.log(Level.FINEST, "Closing ArangoDBDocumentManager resource, database name: " + manager.name());
        manager.close();
    }
}

