/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jnosql.databases.arangodb.mapping;

import jakarta.enterprise.context.spi.CreationalContext;
import jakarta.enterprise.inject.Default;
import jakarta.enterprise.util.AnnotationLiteral;
import java.lang.annotation.Annotation;
import java.lang.reflect.Proxy;
import java.lang.reflect.Type;
import java.util.Collections;
import java.util.Set;
import org.eclipse.jnosql.databases.arangodb.mapping.ArangoDBDocumentRepositoryProxy;
import org.eclipse.jnosql.databases.arangodb.mapping.ArangoDBRepository;
import org.eclipse.jnosql.databases.arangodb.mapping.ArangoDBTemplate;
import org.eclipse.jnosql.mapping.core.Converters;
import org.eclipse.jnosql.mapping.core.spi.AbstractBean;
import org.eclipse.jnosql.mapping.metadata.EntitiesMetadata;

class ArangoDBRepositoryBean<T, K>
extends AbstractBean<ArangoDBRepository<T, K>> {
    private final Class<T> type;
    private final Set<Type> types;
    private final Set<Annotation> qualifiers = Collections.singleton(new AnnotationLiteral<Default>(){});

    ArangoDBRepositoryBean(Class type) {
        this.type = type;
        this.types = Collections.singleton(type);
    }

    public Class<?> getBeanClass() {
        return this.type;
    }

    public ArangoDBRepository<T, K> create(CreationalContext<ArangoDBRepository<T, K>> creationalContext) {
        ArangoDBTemplate template = (ArangoDBTemplate)this.getInstance(ArangoDBTemplate.class);
        Converters converters = (Converters)this.getInstance(Converters.class);
        EntitiesMetadata entitiesMetadata = (EntitiesMetadata)this.getInstance(EntitiesMetadata.class);
        ArangoDBDocumentRepositoryProxy handler = new ArangoDBDocumentRepositoryProxy(template, this.type, converters, entitiesMetadata);
        return (ArangoDBRepository)Proxy.newProxyInstance(this.type.getClassLoader(), new Class[]{this.type}, handler);
    }

    public Set<Type> getTypes() {
        return this.types;
    }

    public Set<Annotation> getQualifiers() {
        return this.qualifiers;
    }

    public String getId() {
        return this.type.getName() + "@orientdb";
    }
}

